/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scouter.client.configuration.exception.ConfigLoadException;
import scouter.client.configuration.views.ConfApplyScopeEnum;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class ConfigureFileHandleUtil {
    public static Map<AgentObject, Boolean> applyConfig(ConfApplyScopeEnum scope, String confKey, String confValue, String objType, int serverId) {
        Map<AgentObject, Boolean> resultMap = null;
        switch (scope) {
            case TYPE_IN_SERVER: {
                resultMap = ConfigureFileHandleUtil.applyConfigToTypeInServer(confKey, confValue, objType, serverId);
                break;
            }
            case TYPE_ALL: {
                resultMap = ConfigureFileHandleUtil.applyConfigToTypeAllServer(confKey, confValue, objType);
                break;
            }
            case FAMILY_IN_SERVER: {
                break;
            }
        }
        return resultMap;
    }

    private static Map<AgentObject, Boolean> applyConfigToTypeAllServer(String confKey, String confValue, String objType) {
        return ConfigureFileHandleUtil.applyConfigToTypeInServer(confKey, confValue, objType, 0);
    }

    private static Map<AgentObject, Boolean> applyConfigToTypeInServer(String confKey, String confValue, String objType, int serverId) {
        HashMap<AgentObject, Boolean> resultMap = new HashMap<AgentObject, Boolean>();
        AgentModelThread.getInstance().getAgentObjectMap().values().stream().filter(object -> objType.equals(object.getObjType())).filter(object -> serverId == 0 || object.getServerId() == serverId).forEach(object -> {
            try {
                if (!object.isAlive()) {
                    resultMap.put((AgentObject)object, false);
                } else {
                    String text = ConfigureFileHandleUtil.loadConfigureText(object.getServerId(), object.getObjHash());
                    Pattern pattern = Pattern.compile("(?m)^" + confKey + "\\s*=.*\\n?");
                    Matcher matcher = pattern.matcher(text);
                    String replacement = String.valueOf(confKey) + "=" + confValue + "\n";
                    String replacedText = null;
                    replacedText = matcher.find() ? matcher.replaceFirst(replacement) : text + "\n\n#auto-added\n" + replacement;
                    if (ConfigureFileHandleUtil.saveConfigure(object.getServerId(), object.getObjHash(), replacedText)) {
                        resultMap.put((AgentObject)object, true);
                    } else {
                        resultMap.put((AgentObject)object, false);
                    }
                }
            }
            catch (ConfigLoadException e) {
                resultMap.put((AgentObject)object, false);
            }
        });
        return resultMap;
    }

    public static String loadConfigureText(int serverId) throws ConfigLoadException {
        return ConfigureFileHandleUtil.loadConfigureText(serverId, 0);
    }

    public static String loadConfigureText(int serverId, int objHash) throws ConfigLoadException {
        String content = null;
        MapPack resultMapPack = null;
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            try {
                MapPack param = new MapPack();
                param.put("objHash", (long)objHash);
                resultMapPack = (MapPack)tcp.getSingle("GET_CONFIGURE_WAS", (Pack)param);
            }
            catch (Throwable throwable) {
                ConsoleProxy.errorSafe(String.valueOf(throwable.getMessage()) + " : error on loadConfigureText.");
                throw new ConfigLoadException();
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        if (resultMapPack != null) {
            content = objHash == 0 ? resultMapPack.getText("serverConfig") : resultMapPack.getText("agentConfig");
        }
        return content;
    }

    public static boolean saveConfigure(int serverId, String configText) {
        return ConfigureFileHandleUtil.saveConfigure(serverId, 0, configText);
    }

    public static boolean saveConfigure(int serverId, int objHash, String configText) {
        boolean success;
        block8: {
            success = false;
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("setConfig", configText.replaceAll("\\\\", "\\\\\\\\"));
                    MapPack out = null;
                    if (objHash == 0) {
                        out = (MapPack)tcp.getSingle("SET_CONFIGURE_SERVER", (Pack)param);
                    } else {
                        param.put("objHash", (long)objHash);
                        out = (MapPack)tcp.getSingle("SET_CONFIGURE_WAS", (Pack)param);
                    }
                    if (out == null) break block8;
                    String config = out.getText("result");
                    if ("true".equalsIgnoreCase(config)) {
                        success = true;
                        break block8;
                    }
                    success = false;
                }
                catch (Throwable throwable) {
                    success = false;
                    ConsoleProxy.errorSafe(String.valueOf(throwable.getMessage()) + " : error on saveConfigure.");
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
        return success;
    }
}

