/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import scouter.client.configuration.views.ConfApplyScopeEnum;
import scouter.client.model.AgentModelThread;
import scouter.lang.conf.ValueType;
import scouter.lang.conf.ValueTypeDesc;
import scouter.util.StringUtil;

public class ConfigureItemDialog
extends TitleAreaDialog {
    String confKey;
    String valueOrg;
    String objName;
    String desc;
    ValueType valueType;
    ValueTypeDesc valueTypeDesc;
    boolean isServer;
    int objHash;
    String objType;
    String value;
    List<Text> texts = new ArrayList<Text>();
    ConfApplyScopeEnum applyScope = ConfApplyScopeEnum.THIS;
    Widget lastFocusedText;

    public ConfigureItemDialog(Shell parentShell, String confKey, String valueOrg, String objName, String desc, ValueType valueType, ValueTypeDesc valueTypeDesc, boolean isServer, int objHash) {
        super(parentShell);
        this.confKey = confKey;
        this.objName = objName;
        this.desc = desc;
        this.valueType = valueType == null ? ValueType.VALUE : valueType;
        this.valueTypeDesc = valueTypeDesc == null ? new ValueTypeDesc() : valueTypeDesc;
        this.valueOrg = valueOrg;
        if (this.valueOrg == null) {
            this.valueOrg = "";
        }
        this.value = this.shape(valueOrg);
        this.isServer = isServer;
        this.objHash = objHash;
        if (!isServer) {
            this.objType = AgentModelThread.getInstance().getAgentObject(objHash).getObjType();
        }
    }

    public void create() {
        super.create();
        this.setTitle("\"" + this.confKey + "\" (" + this.objName + ")");
        if (StringUtil.isNotEmpty((String)this.desc)) {
            this.setMessage(this.desc, 1);
        } else {
            this.setMessage("Set the value of : " + this.confKey, 1);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Text serviceTxt;
        Composite container = (Composite)super.createDialogArea(parent);
        this.setShellStyle(2144);
        this.setBlockOnOpen(true);
        final ScrolledComposite scrolled = new ScrolledComposite(container, 768);
        GridData data = new GridData(4, 4, true, true);
        scrolled.setLayoutData((Object)data);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        final Group group = new Group((Composite)scrolled, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolled.setContent((Control)group);
        scrolled.setMinSize(group.computeSize(-1, -1));
        if (this.valueType == ValueType.VALUE) {
            group.setLayout((Layout)new GridLayout(1, false));
            serviceTxt = new Text((Composite)group, 2052);
            serviceTxt.setLayoutData((Object)new GridData(4, 4, true, false));
            serviceTxt.setText(this.value);
            serviceTxt.addModifyListener(e -> {
                String string = this.value = ((Text)e.getSource()).getText();
            });
        } else if (this.valueType == ValueType.COMMA_COLON_SEPARATED_VALUE) {
            data.heightHint = 250;
            final FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ConfigureItemDialog.this.lastFocusedText = focusEvent.widget;
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            };
            final String[] strings = this.valueTypeDesc.getStrings();
            boolean[] booleans = this.valueTypeDesc.getBooleans();
            if (strings == null || strings.length == 0) {
                group.setLayout((Layout)new GridLayout(1, false));
                Text serviceTxt2 = new Text((Composite)group, 2818);
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = 150;
                serviceTxt2.setLayoutData((Object)gridData);
                serviceTxt2.setText(this.value);
                serviceTxt2.addModifyListener(e -> {
                    String string = this.value = ((Text)e.getSource()).getText();
                });
            } else {
                String[] lines;
                group.setLayout((Layout)new GridLayout(strings.length, false));
                Composite buttonArea = new Composite((Composite)group, 0);
                buttonArea.setLayout((Layout)new RowLayout());
                buttonArea.setLayoutData((Object)new GridData(4, 4, true, false, strings.length, 1));
                Button buttonAdd = new Button(buttonArea, 8);
                buttonAdd.setText("+");
                Button buttonRemove = new Button(buttonArea, 8);
                buttonRemove.setText("-");
                buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int i = 0;
                        while (i < strings.length) {
                            Text text = new Text((Composite)group, 0x1000000);
                            text.setText("");
                            text.setLayoutData((Object)new GridData(4, 4, true, false));
                            text.addFocusListener(focusListener);
                            ConfigureItemDialog.this.texts.add(text);
                            ++i;
                        }
                        group.layout(true, true);
                        group.setSize(group.computeSize(-1, -1));
                        scrolled.setMinSize(group.computeSize(-1, -1));
                    }
                });
                buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (ConfigureItemDialog.this.lastFocusedText != null) {
                            int firstTextIndex;
                            int selectedIndex = ConfigureItemDialog.this.texts.indexOf(ConfigureItemDialog.this.lastFocusedText);
                            if (selectedIndex < 0) {
                                return;
                            }
                            int i = firstTextIndex = selectedIndex / strings.length * strings.length;
                            while (i < firstTextIndex + strings.length) {
                                ConfigureItemDialog.this.texts.get(i).dispose();
                                group.layout(true, true);
                                group.setSize(group.computeSize(-1, -1));
                                scrolled.setMinSize(group.computeSize(-1, -1));
                                ++i;
                            }
                            boolean focused = false;
                            int i2 = firstTextIndex + strings.length;
                            while (i2 < ConfigureItemDialog.this.texts.size()) {
                                if (!ConfigureItemDialog.this.texts.get(i2).isDisposed()) {
                                    ConfigureItemDialog.this.texts.get(i2).setFocus();
                                    focused = true;
                                    break;
                                }
                                i2 += strings.length;
                            }
                            if (!focused) {
                                i2 = firstTextIndex - strings.length;
                                while (i2 >= 0) {
                                    if (!ConfigureItemDialog.this.texts.get(i2).isDisposed()) {
                                        ConfigureItemDialog.this.texts.get(i2).setFocus();
                                        break;
                                    }
                                    i2 -= strings.length;
                                }
                            }
                        }
                    }
                });
                int i = 0;
                while (i < strings.length) {
                    String colName = strings[i];
                    Label col = new Label((Composite)group, 0x1000000);
                    col.setText(colName);
                    col.setLayoutData((Object)new GridData(4, 4, true, false));
                    if (booleans != null && booleans.length > i && booleans[i]) {
                        FontData fontData = col.getFont().getFontData()[0];
                        Font font = new Font(null, new FontData(fontData.getName(), fontData.getHeight(), 1));
                        col.setFont(font);
                    }
                    ++i;
                }
                String[] stringArray = lines = StringUtil.split((String)this.valueOrg, (char)',');
                int n = lines.length;
                int col = 0;
                while (col < n) {
                    String line = stringArray[col];
                    String[] values = StringUtil.split((String)line, (char)':');
                    if (values.length >= 0) {
                        int i2 = 0;
                        while (i2 < strings.length) {
                            Text text = new Text((Composite)group, 0x1000000);
                            if (values.length > i2 && StringUtil.isNotEmpty((String)values[i2])) {
                                text.setText(values[i2]);
                            }
                            text.setLayoutData((Object)new GridData(4, 4, true, false));
                            text.addFocusListener(focusListener);
                            this.texts.add(text);
                            ++i2;
                        }
                    }
                    ++col;
                }
                int i3 = 0;
                while (i3 < strings.length) {
                    Text text = new Text((Composite)group, 0x1000000);
                    text.setLayoutData((Object)new GridData(4, 4, true, false));
                    text.addFocusListener(focusListener);
                    this.texts.add(text);
                    ++i3;
                }
            }
        } else if (this.valueType == ValueType.COMMA_SEPARATED_VALUE) {
            group.setLayout((Layout)new GridLayout(1, false));
            serviceTxt = new Text((Composite)group, 2818);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 100;
            serviceTxt.setLayoutData((Object)gridData);
            serviceTxt.setText(this.value);
            serviceTxt.addModifyListener(e -> {
                String string = this.value = ((Text)e.getSource()).getText();
            });
        } else if (this.valueType == ValueType.NUM) {
            group.setLayout((Layout)new GridLayout(1, false));
            serviceTxt = new Text((Composite)group, 2052);
            serviceTxt.setLayoutData((Object)new GridData(4, 4, true, false));
            serviceTxt.addVerifyListener(e -> {
                boolean bl = e.doit = this.isNumber(e.text);
            });
            serviceTxt.setText(this.value);
            serviceTxt.addModifyListener(e -> {
                String string = this.value = ((Text)e.getSource()).getText();
            });
        } else if (this.valueType == ValueType.BOOL) {
            group.setLayout((Layout)new GridLayout(1, false));
            Button button = new Button((Composite)group, 32);
            button.setLayoutData((Object)new GridData(4, 4, true, false));
            button.setText(this.confKey);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigureItemDialog.this.value = ((Button)e.widget).getSelection() ? "true" : "false";
                }
            });
            button.setSelection("true".equals(this.value));
        } else {
            group.setLayout((Layout)new GridLayout(1, false));
            serviceTxt = new Text((Composite)group, 2052);
            serviceTxt.setLayoutData((Object)new GridData(4, 4, true, false));
            serviceTxt.setText(this.value);
            serviceTxt.addModifyListener(e -> {
                String string = this.value = ((Text)e.getSource()).getText();
            });
        }
        if (!this.isServer) {
            Group applyTypeGroup = new Group((Composite)group, 0);
            applyTypeGroup.setLayout((Layout)new RowLayout(512));
            applyTypeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            applyTypeGroup.setText("Select title");
            Button rdOnlyThis = new Button((Composite)applyTypeGroup, 16);
            rdOnlyThis.setText("to this object (you should save it manually after done)");
            rdOnlyThis.setSelection(true);
            Button rdForType = new Button((Composite)applyTypeGroup, 16);
            rdForType.setText("to all same type objects(" + this.objType + ") in this collector.(the configuration will be saved automatically)");
            Button rdForTypeAll = new Button((Composite)applyTypeGroup, 16);
            rdForTypeAll.setText("to all same type objects(" + this.objType + ") for all collectors.(the configuration will be saved automatically)");
            rdOnlyThis.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        ConfigureItemDialog.this.applyScope = ConfApplyScopeEnum.THIS;
                    }
                }
            });
            rdForType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        ConfigureItemDialog.this.applyScope = ConfApplyScopeEnum.TYPE_IN_SERVER;
                    }
                }
            });
            rdForTypeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        ConfigureItemDialog.this.applyScope = ConfApplyScopeEnum.TYPE_ALL;
                    }
                }
            });
        }
        return container;
    }

    private boolean isNumber(String v) {
        char[] chars = new char[v.length()];
        v.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            if ('0' > chars[i] || chars[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.checkData()) {
            return;
        }
        super.okPressed();
    }

    private boolean checkData() {
        if (this.valueType == ValueType.COMMA_COLON_SEPARATED_VALUE) {
            String[] strings = this.valueTypeDesc.getStrings();
            boolean[] booleans = this.valueTypeDesc.getBooleans();
            if (strings != null || strings.length > 0) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < this.texts.size()) {
                    if (!this.texts.get(i).isDisposed()) {
                        boolean allBlank = true;
                        int j = i;
                        while (j < i + strings.length) {
                            if (StringUtil.isNotEmpty((String)this.texts.get(j).getText())) {
                                allBlank = false;
                                break;
                            }
                            ++j;
                        }
                        if (allBlank) {
                            j = i;
                            while (j < i + strings.length) {
                                this.texts.get(j).dispose();
                                ++j;
                            }
                        }
                    }
                    i += strings.length;
                }
                i = 0;
                while (i < this.texts.size()) {
                    if (!this.texts.get(i).isDisposed()) {
                        int itemGroupPos = i % strings.length;
                        if (booleans != null && booleans.length > itemGroupPos && booleans[itemGroupPos] && StringUtil.isEmpty((String)this.texts.get(i).getText())) {
                            MessageDialog.openWarning((Shell)this.getShell(), (String)"Missing required", (String)"Missing required.");
                            this.texts.get(i).setFocus();
                            return false;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < this.texts.size()) {
                    if (!this.texts.get(i).isDisposed()) {
                        if (i != 0 && i % strings.length == 0) {
                            sb.append(',');
                        } else if (i != 0) {
                            sb.append(':');
                        }
                        sb.append(this.texts.get(i).getText());
                    }
                    ++i;
                }
                this.value = sb.toString();
            }
        }
        return true;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(600, -1);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure item detail");
    }

    protected boolean isResizable() {
        return true;
    }

    private String unShape(String value0) {
        if (this.valueType == ValueType.COMMA_SEPARATED_VALUE) {
            return value0.replaceAll("\\s+", ",");
        }
        return value0;
    }

    private String shape(String value0) {
        if (this.valueType == ValueType.COMMA_SEPARATED_VALUE) {
            return value0.replace(',', '\n');
        }
        return value0;
    }

    public String getValue() {
        return this.unShape(this.value);
    }

    public ConfApplyScopeEnum getApplyScope() {
        return this.applyScope;
    }
}

