/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.configuration.views.ConfApplyScopeEnum;
import scouter.client.configuration.views.ConfEnum;
import scouter.client.configuration.views.ConfObject;
import scouter.client.configuration.views.ConfigureFileHandleUtil;
import scouter.client.configuration.views.ConfigureItemDialog;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ColoringWord;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.conf.ValueType;
import scouter.lang.conf.ValueTypeDesc;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class ConfigureView
extends ViewPart {
    public static final String ID = ConfigureView.class.getName();
    private ArrayList<ColoringWord> defaultHighlightings;
    private ArrayList<ColoringWord> defaultTaggedHighlightings;
    private HashSet<String> configKeyNames = new HashSet();
    private StyledText text;
    private String content;
    private int serverId;
    private int objHash;
    private String displayName;
    private volatile String selectedText = "";
    private volatile long selectedTime = 0L;
    private volatile int selectedX = 0;
    private volatile int selectedY = 0;
    Composite listComp;
    TableViewer viewer;
    Table table;
    Text searchTxt;
    TableColumnLayout tableColumnLayout;
    private Clipboard clipboard = new Clipboard(null);
    CustomLineStyleListener listener;
    boolean devMode;
    HashMap<String, String> descMap = new HashMap();
    HashMap<String, ValueType> valueTypeMap = new HashMap();
    HashMap<String, ValueTypeDesc> valueTypeDescMap = new HashMap();
    ArrayList<ConfObject> configList = new ArrayList();
    ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (ConfigureView.this.devMode) {
                return true;
            }
            return !(element instanceof ConfObject) || !((ConfObject)element).key.startsWith("_");
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.SASH_WIDTH = 1;
        this.initialStyledText((Composite)sashForm);
        this.listComp = new Composite((Composite)sashForm, 0);
        this.listComp.setLayout((Layout)new GridLayout(1, true));
        Composite searchComp = new Composite(this.listComp, 0);
        searchComp.setLayoutData((Object)new GridData(4, 4, true, false));
        searchComp.setLayout((Layout)new GridLayout(2, false));
        Label searchLabel = new Label(searchComp, 2048);
        searchLabel.setText("Filter : ");
        this.searchTxt = new Text(searchComp, 2048);
        this.searchTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchTxt.setToolTipText("Search Key/Value");
        this.searchTxt.addMouseListener(new MouseListener(){
            int clicked;

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                ++this.clicked;
                if (this.clicked == 10) {
                    ConfigureView.this.devMode = true;
                    ConfigureView.this.viewer.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.searchTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String searchText = ConfigureView.this.searchTxt.getText();
                if (StringUtil.isEmpty((String)searchText)) {
                    ConfigureView.this.viewer.setInput(ConfigureView.this.configList);
                } else {
                    searchText = searchText.toLowerCase();
                    ArrayList<ConfObject> tempList = new ArrayList<ConfObject>();
                    for (ConfObject data : ConfigureView.this.configList) {
                        String name = data.key.toLowerCase();
                        String value = data.value.toLowerCase();
                        if (!name.contains(searchText) && !value.contains(searchText)) continue;
                        tempList.add(data);
                    }
                    ConfigureView.this.viewer.setInput(tempList);
                }
            }
        });
        Composite tableComp = new Composite(this.listComp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(tableComp, 68418);
        this.createColumns();
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        this.viewer.addFilter(this.filter);
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.table, 1, true);
        toolTip.setFont(new Font(null, "Arial", 11, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String configName;
                String desc;
                toolTip.hide();
                StructuredSelection sel = (StructuredSelection)ConfigureView.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ConfObject && StringUtil.isNotEmpty((String)(desc = ConfigureView.this.descMap.get(configName = ((ConfObject)o).key)))) {
                    toolTip.setText(desc);
                    toolTip.show(new Point(e.x + 10, e.y + 20));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                StructuredSelection selection = (StructuredSelection)ConfigureView.this.viewer.getSelection();
                if (selection == null) {
                    return;
                }
                ConfObject confObject = (ConfObject)selection.getFirstElement();
                if (confObject != null) {
                    String configText = ConfigureView.this.text.getText();
                    if (configText == null || configText.indexOf(confObject.key) >= 0) {
                        return;
                    }
                    String desc = ConfigureView.this.descMap.get(confObject.key);
                    if (StringUtil.isNotEmpty((String)desc)) {
                        desc = desc.replace("\n", "\n#");
                        ConfigureView.this.text.setText(String.valueOf(configText) + "\n\n" + "#" + desc);
                    }
                    ConfigureView.this.text.setText(String.valueOf(ConfigureView.this.text.getText()) + "\n" + confObject.key + "=" + confObject.value);
                }
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.stateMask != 262144 && e.stateMask != 0x400000 || e.keyCode != 99 && e.keyCode != 67)) {
                    TableItem[] items = ConfigureView.this.table.getSelection();
                    if (items == null || items.length < 1) {
                        return;
                    }
                    StringBuffer sb = new StringBuffer();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        String desc = ConfigureView.this.descMap.get(item.getText(0));
                        if (StringUtil.isNotEmpty((String)desc)) {
                            sb.append("#").append(desc.replace("\n", "\n#")).append("\n");
                        }
                        sb.append(item.getText(0));
                        sb.append("=");
                        sb.append(item.getText(1));
                        sb.append("\n");
                        ++n2;
                    }
                    ConfigureView.this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        Label bottomLabel = new Label(this.listComp, 2048);
        bottomLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        bottomLabel.setFont(new Font(null, "Arial", 11, 3));
        bottomLabel.setBackground(Display.getCurrent().getSystemColor(29));
        bottomLabel.setText("  [Click] for tooltip\n" + "  [Double-Click] for copy && paste (or ctl+C)");
        sashForm.setWeights(new int[]{1, 1});
        sashForm.setMaximizedControl(null);
        this.initialToolBar();
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server != null) {
            this.displayName = server.getName();
            this.setPartName("Config Server[" + server.getName() + "]");
            this.loadConfig("GET_CONFIGURE_SERVER", null);
            this.loadConfigList("LIST_CONFIGURE_SERVER", null);
            this.loadConfigDesc(new MapPack());
            this.loadConfigValueType(new MapPack());
            this.loadConfigValueTypeDesc(new MapPack());
        }
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server != null) {
            this.displayName = TextProxy.object.getText(objHash);
            this.setPartName("Config Agent[" + TextProxy.object.getText(objHash) + "]");
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            this.loadConfig("GET_CONFIGURE_WAS", param);
            this.loadConfigList("LIST_CONFIGURE_WAS", param);
            this.loadConfigDesc(param);
            this.loadConfigValueType(param);
        }
    }

    private void initialStyledText(final Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        this.text = new StyledText(comp, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listener = new CustomLineStyleListener(true, this.defaultHighlightings, this.defaultTaggedHighlightings, false);
        this.text.addLineStyleListener((LineStyleListener)this.listener);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 || e.stateMask == 0x400000) {
                    if (e.keyCode == 115 || e.keyCode == 83) {
                        ConfigureView.this.saveConfigurations();
                    } else if (e.keyCode == 97 || e.keyCode == 65) {
                        ConfigureView.this.text.selectAll();
                    }
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ConfigureView.this.selectedTime > System.currentTimeMillis() - 1500L) {
                    char c;
                    String contents = ConfigureView.this.text.getText();
                    int start = ConfigureView.this.selectedX;
                    int end = ConfigureView.this.selectedY;
                    while (start > 0) {
                        if ((c = contents.charAt(--start)) >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '$') continue;
                        ++start;
                        break;
                    }
                    while (end < contents.length()) {
                        if ((c = contents.charAt(end++)) >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '$') continue;
                        --end;
                        break;
                    }
                    ConfigureView.this.selectedX = start;
                    ConfigureView.this.selectedY = end;
                    ConfigureView.this.selectedText = contents.substring(start, end);
                    ConfigureView.this.text.setSelection(start, end);
                    if (ConfigureView.this.configKeyContains(ConfigureView.this.selectedText)) {
                        String fullText = ConfigureView.this.text.getText();
                        String textToIt = fullText.substring(0, ConfigureView.this.selectedX);
                        int lastIndexOfLineBreakToIt = Math.max(textToIt.lastIndexOf(10), textToIt.lastIndexOf(13));
                        if (lastIndexOfLineBreakToIt >= 0 ? fullText.charAt(lastIndexOfLineBreakToIt + 1) == '#' : textToIt.length() > 0 && textToIt.charAt(0) == '#') {
                            return;
                        }
                        String value = fullText.substring(ConfigureView.this.selectedY);
                        int startPos = value.indexOf(61) + 1;
                        int npos = value.indexOf(10);
                        int rpos = value.indexOf(13);
                        int lineEndPos = npos >= 0 && rpos >= 0 ? Math.min(npos, rpos) : Math.max(npos, rpos);
                        value = lineEndPos >= 0 ? value.substring(startPos, lineEndPos) : value.substring(startPos);
                        String valuef = value;
                        ExUtil.exec(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), () -> {
                            ConfigureItemDialog dialog = new ConfigureItemDialog(parent.getShell(), ConfigureView.this.selectedText, valuef, ConfigureView.this.displayName, ConfigureView.this.getInDescMap(ConfigureView.this.selectedText), ConfigureView.this.getInValueTypeMap(ConfigureView.this.selectedText), ConfigureView.this.getInValueTypeDescMap(ConfigureView.this.selectedText), ConfigureView.this.objHash == 0, ConfigureView.this.objHash);
                            if (dialog.open() == 0) {
                                ConfigureView.this.setTheConfig(ConfigureView.this.selectedText, dialog.getValue(), dialog.getApplyScope());
                            }
                        });
                    }
                }
            }
        });
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.x == e.y) {
                    return;
                }
                ConfigureView.this.selectedText = ConfigureView.this.text.getText(e.x, e.y - 1);
                ConfigureView.this.selectedTime = System.currentTimeMillis();
                ConfigureView.this.selectedX = e.x;
                ConfigureView.this.selectedY = e.y;
            }
        });
        Label bottomLabel = new Label(comp, 2048);
        bottomLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        bottomLabel.setFont(new Font(null, "Arial", 11, 3));
        bottomLabel.setBackground(Display.getCurrent().getSystemColor(29));
        bottomLabel.setText("  [Double-Click] the config KEY for popup editor\n" + " ");
    }

    private boolean configKeyContains(String text) {
        if (this.configKeyNames.contains(text)) {
            return true;
        }
        String pureText = ConfigureView.removeVariableString(text);
        for (String key : this.configKeyNames) {
            if (!ConfigureView.removeVariableString(key).equals(pureText)) continue;
            return true;
        }
        return false;
    }

    private String getInDescMap(String text) {
        String desc = this.descMap.get(text);
        if (desc == null) {
            desc = this.descMap.get(ConfigureView.removeVariableString(text));
        }
        return desc;
    }

    private ValueType getInValueTypeMap(String text) {
        ValueType valueType = this.valueTypeMap.get(text);
        if (valueType == null) {
            valueType = this.valueTypeMap.get(ConfigureView.removeVariableString(text));
        }
        return valueType;
    }

    private ValueTypeDesc getInValueTypeDescMap(String text) {
        ValueTypeDesc valueTypeDesc = this.valueTypeDescMap.get(text);
        if (valueTypeDesc == null) {
            valueTypeDesc = this.valueTypeDescMap.get(ConfigureView.removeVariableString(text));
        }
        return valueTypeDesc;
    }

    public static String removeVariableString(String text) {
        StringBuilder resultBuilder = new StringBuilder(text.length());
        char[] org = text.toCharArray();
        boolean sink = false;
        int i = 0;
        while (i < org.length) {
            switch (org[i]) {
                case '$': {
                    sink = !sink;
                    break;
                }
                default: {
                    if (sink) break;
                    resultBuilder.append(org[i]);
                }
            }
            ++i;
        }
        return resultBuilder.toString();
    }

    private void setTheConfig(String confKey, String confValue, ConfApplyScopeEnum applyScope) {
        String _confValue = confValue;
        if ("null".equals(_confValue)) {
            _confValue = "";
        }
        String content = this.text.getText();
        String expression = "(?m)^" + confKey.replace("$", "\\$") + "\\s*=.*\\n?";
        String replacement = String.valueOf(confKey) + "=" + _confValue + "\n";
        try {
            content = content.replaceAll(expression, Matcher.quoteReplacement(replacement));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.text.setText(content);
        if (this.objHash == 0) {
            return;
        }
        ExUtil.exec(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), () -> {
            String objType = AgentModelThread.getInstance().getAgentObject(this.objHash).getObjType();
            Map<AgentObject, Boolean> resultMap = ConfigureFileHandleUtil.applyConfig(applyScope, confKey, confValue, objType, this.serverId);
            if (resultMap == null) {
                return;
            }
            if (resultMap.values().contains(Boolean.FALSE)) {
                new EditableMessageDialog().show("Saved with Warning!", "Configuration saving is partially success.\n\n" + resultMap.entrySet().stream().map(e -> " - " + e.getKey() + " : " + ((Boolean)e.getValue() != false ? "success" : "fail")).collect(Collectors.joining("\n")));
            } else {
                new EditableMessageDialog().show("Saved all successfully.", "Configuration saving is done.\n\n" + resultMap.entrySet().stream().map(e -> " - " + e.getKey() + " : " + ((Boolean)e.getValue() != false ? "success" : "fail")).collect(Collectors.joining("\n")));
            }
        });
    }

    private void saveConfigurations() {
        block10: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("setConfig", this.text.getText().replaceAll("\\\\", "\\\\\\\\"));
                    MapPack out = null;
                    if (this.objHash == 0) {
                        out = (MapPack)tcp.getSingle("SET_CONFIGURE_SERVER", (Pack)param);
                    } else {
                        param.put("objHash", (long)this.objHash);
                        out = (MapPack)tcp.getSingle("SET_CONFIGURE_WAS", (Pack)param);
                    }
                    if (out == null) break block10;
                    String config = out.getText("result");
                    if ("true".equalsIgnoreCase(config)) {
                        MessageDialog.open((int)2, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Success", (String)"Configuration saving is done.", (int)0);
                        if (this.objHash == 0) {
                            this.loadConfigList("LIST_CONFIGURE_SERVER", null);
                        } else {
                            MapPack param2 = new MapPack();
                            param2.put("objHash", (long)this.objHash);
                            this.loadConfigList("LIST_CONFIGURE_WAS", param2);
                        }
                        break block10;
                    }
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Configuration saving is failed.");
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
    }

    private void initialToolBar() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Save", ImageUtil.getImageDescriptor(Images.save)){

            public void run() {
                ConfigureView.this.saveConfigurations();
            }
        });
    }

    private void loadConfig(final String requestCmd, final MapPack param) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack = null;
                TcpProxy tcp = TcpProxy.getTcpProxy(ConfigureView.this.serverId);
                try {
                    mpack = (MapPack)tcp.getSingle(requestCmd, (Pack)param);
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    ListValue configKey = mpack.getList("configKey");
                    ConfigureView.this.defaultHighlightings = new ArrayList();
                    ConfigureView.this.defaultTaggedHighlightings = new ArrayList();
                    int inx = 0;
                    while (configKey != null && inx < configKey.size()) {
                        ConfigureView.this.defaultHighlightings.add(new ColoringWord(configKey.getString(inx), 9, true));
                        if (configKey.getString(inx).contains("$")) {
                            ConfigureView.this.defaultTaggedHighlightings.add(new ColoringWord(ConfigureView.removeVariableString(configKey.getString(inx)), 9, true));
                        }
                        ConfigureView.this.configKeyNames.add(configKey.getString(inx));
                        ++inx;
                    }
                    ConfigureView.this.defaultHighlightings.add(new ColoringWord(";", 3, true));
                    ConfigureView.this.content = ConfigureView.this.objHash == 0 ? mpack.getText("serverConfig") : mpack.getText("agentConfig");
                }
                ExUtil.exec((Composite)ConfigureView.this.text, new Runnable(){

                    @Override
                    public void run() {
                        (this).ConfigureView.this.listener.setKeywordArray((this).ConfigureView.this.defaultHighlightings);
                        (this).ConfigureView.this.listener.setTaggedKeywordArray((this).ConfigureView.this.defaultTaggedHighlightings);
                        (this).ConfigureView.this.text.setText((this).ConfigureView.this.content);
                    }
                });
            }
        });
    }

    private void loadConfigList(final String requestCmd, final MapPack param) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block7: {
                    pack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ConfigureView.this.serverId);
                    try {
                        try {
                            pack = (MapPack)tcp.getSingle(requestCmd, (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    ListValue keyList = pack.getList("key");
                    ListValue valueList = pack.getList("value");
                    ListValue defaultList = pack.getList("default");
                    ConfigureView.this.configList.clear();
                    int i = 0;
                    while (i < keyList.size()) {
                        ConfObject obj = new ConfObject();
                        String key = CastUtil.cString((Object)keyList.get(i));
                        String value = CastUtil.cString((Object)valueList.get(i));
                        String def = CastUtil.cString((Object)defaultList.get(i));
                        obj.key = key == null ? "" : key;
                        obj.value = value == null ? "" : value;
                        obj.def = def == null ? "" : def;
                        ConfigureView.this.configList.add(obj);
                        ++i;
                    }
                    ExUtil.exec(ConfigureView.this.listComp, new Runnable(){

                        @Override
                        public void run() {
                            (this).ConfigureView.this.searchTxt.notifyListeners(24, new Event());
                        }
                    });
                }
            }
        });
    }

    private void loadConfigDesc(final MapPack param) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block7: {
                    pack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ConfigureView.this.serverId);
                    try {
                        try {
                            pack = (MapPack)tcp.getSingle("CONFIGURE_DESC", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    Iterator keys = pack.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        ConfigureView.this.descMap.put(key, pack.getText(key));
                        if (!key.contains("$")) continue;
                        ConfigureView.this.descMap.put(ConfigureView.removeVariableString(key), pack.getText(key));
                    }
                }
            }
        });
    }

    private void loadConfigValueType(final MapPack param) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block7: {
                    pack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ConfigureView.this.serverId);
                    try {
                        try {
                            pack = (MapPack)tcp.getSingle("CONFIGURE_VALUE_TYPE", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    Iterator keys = pack.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        ConfigureView.this.valueTypeMap.put(key, ValueType.of((int)pack.getInt(key)));
                        if (!key.contains("$")) continue;
                        ConfigureView.this.valueTypeMap.put(ConfigureView.removeVariableString(key), ValueType.of((int)pack.getInt(key)));
                    }
                }
            }
        });
    }

    private void loadConfigValueTypeDesc(final MapPack param) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack;
                block7: {
                    pack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ConfigureView.this.serverId);
                    try {
                        try {
                            pack = (MapPack)tcp.getSingle("CONFIGURE_VALUE_TYPE_DESC", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (pack != null) {
                    Iterator keys = pack.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        ConfigureView.this.valueTypeDescMap.put(key, ValueTypeDesc.of((MapValue)((MapValue)pack.get(key))));
                        if (!key.contains("$")) continue;
                        ConfigureView.this.valueTypeDescMap.put(ConfigureView.removeVariableString(key), ValueTypeDesc.of((MapValue)((MapValue)pack.get(key))));
                    }
                }
            }
        });
    }

    public void setFocus() {
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage("CTRL + S : save configurations, CTRL + A : select all text");
    }

    private void createColumns() {
        ConfEnum[] confEnumArray = ConfEnum.values();
        int n = confEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfEnum column = confEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case KEY: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ConfObject) {
                                return ((ConfObject)element).key;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case VALUE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ConfObject) {
                                return ((ConfObject)element).value;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case DEFAULT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ConfObject) {
                                return ((ConfObject)element).def;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, true));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ConfigureView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }
}

