/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class TelegrafFileConfigView
extends ViewPart {
    private int serverId;
    public static final String ID = "scouter.client.configuration.views.TelegrafFileConfigView";
    private Action saveAction;
    private Action reloadAction;
    private Composite mainContainer;
    private String m_tgConfigContents;
    private StyledText styledText;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        this.mainContainer = new Composite(parent, 0);
        this.mainContainer.setLayout((Layout)new FillLayout(256));
        this.styledText = new StyledText(this.mainContainer, 2818);
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TelegrafFileConfigView.this.m_tgConfigContents = TelegrafFileConfigView.this.styledText.getText();
            }
        });
        this.styledText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 || e.stateMask == 0x400000) {
                    if (e.keyCode == 115 || e.keyCode == 83) {
                        TelegrafFileConfigView.this.saveConfig();
                    } else if (e.keyCode == 97 || e.keyCode == 65) {
                        TelegrafFileConfigView.this.styledText.selectAll();
                    }
                }
            }
        });
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createActions() {
        this.saveAction = new Action("Save", ImageUtil.getImageDescriptor(Images.save)){

            public void run() {
                TelegrafFileConfigView.this.saveConfig();
            }
        };
        this.reloadAction = new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                TelegrafFileConfigView.this.loadConfig();
            }
        };
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.reloadAction);
        toolbarManager.add((IAction)this.saveAction);
    }

    private void initializeMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server != null) {
            this.setPartName("Config Telegraf-File Server[" + server.getName() + "]");
            this.loadConfig();
        }
    }

    private void loadConfig() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack = null;
                TcpProxy tcp = TcpProxy.getTcpProxy(TelegrafFileConfigView.this.serverId);
                try {
                    mpack = (MapPack)tcp.getSingle("GET_CONFIGURE_TELEGRAF", null);
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    TelegrafFileConfigView.this.m_tgConfigContents = mpack.getText("tgConfigContents");
                }
                ExUtil.exec(TelegrafFileConfigView.this.mainContainer, new Runnable(){

                    @Override
                    public void run() {
                        (this).TelegrafFileConfigView.this.styledText.setText((this).TelegrafFileConfigView.this.m_tgConfigContents);
                    }
                });
            }
        });
    }

    private void saveConfig() {
        block6: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    String contents = this.m_tgConfigContents;
                    MapPack param = new MapPack();
                    param.put("tgConfigContents", contents);
                    MapPack out = (MapPack)tcp.getSingle("SET_CONFIGURE_TELEGRAF", (Pack)param);
                    if (out == null) break block6;
                    String config = out.getText("result");
                    if ("true".equalsIgnoreCase(config)) {
                        MessageDialog.open((int)2, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Success", (String)"Configuration saving is done.", (int)0);
                        break block6;
                    }
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Configuration saving is failed.");
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
    }
}

