/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views.sub;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import scouter.lang.DeltaType;
import scouter.server.support.telegraf.TgCounterMapping;

public class CounterMappingDeltaTypeSupport
extends EditingSupport {
    private final TableViewer viewer;

    public CounterMappingDeltaTypeSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        String[] deltaTypes = new String[]{DeltaType.NONE.name(), DeltaType.DELTA.name(), DeltaType.BOTH.name()};
        return new ComboBoxCellEditor((Composite)this.viewer.getTable(), deltaTypes);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        TgCounterMapping mapping = (TgCounterMapping)element;
        switch (mapping.deltaType) {
            case NONE: {
                return 0;
            }
            case DELTA: {
                return 1;
            }
            case BOTH: {
                return 2;
            }
        }
        return 0;
    }

    protected void setValue(Object element, Object userInputValue) {
        TgCounterMapping mapping = (TgCounterMapping)element;
        int num = (Integer)userInputValue;
        switch (num) {
            case 0: {
                mapping.deltaType = DeltaType.NONE;
                break;
            }
            case 1: {
                mapping.deltaType = DeltaType.DELTA;
                break;
            }
            case 2: {
                mapping.deltaType = DeltaType.BOTH;
                break;
            }
            default: {
                mapping.deltaType = DeltaType.NONE;
            }
        }
        this.viewer.update(element, null);
    }
}

