/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.context.actions;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.RCPUtil;

public class CloseServerAction
extends Action {
    public static final String ID = CloseServerAction.class.getName();
    private final IWorkbenchWindow window;
    private final int serverId;

    public CloseServerAction(IWorkbenchWindow window, int serverId) {
        super("&Close Server");
        this.window = window;
        this.serverId = serverId;
    }

    public void run() {
        Server newDefault = null;
        if (ServerManager.getInstance().getDefaultServer().getId() == this.serverId) {
            Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerList();
            Integer[] serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
            int i = 0;
            while (i < serverIds.length) {
                if (this.serverId != serverIds[i]) {
                    newDefault = ServerManager.getInstance().getServer(serverIds[i]);
                    break;
                }
                ++i;
            }
        }
        Server server = ServerManager.getInstance().getServer(this.serverId);
        server.close();
        server.setOpen(false);
        if (newDefault != null) {
            ConsoleProxy.infoSafe("Default Server Changed to '" + newDefault.getName() + "'");
            ServerManager.getInstance().setDefaultServer(newDefault);
            ServerPrefUtil.storeDefaultServer(String.valueOf(newDefault.getIp()) + ":" + newDefault.getPort());
            if (MessageDialog.openConfirm((Shell)this.window.getShell(), (String)"Reset Perspectives", (String)"Default server is changed. Would you reset all perspective?")) {
                RCPUtil.resetPerspective();
            }
        }
    }
}

