/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.context.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.util.TimeUtil;
import scouter.client.views.ApiDebugView;

public class OpenAPIDebugViewAction
extends Action {
    public static final String ID = OpenAPIDebugViewAction.class.getName();
    private final IWorkbenchWindow win;
    private int objHash;
    private int serverId;

    public OpenAPIDebugViewAction(IWorkbenchWindow win, int objHash, int serverId) {
        this.win = win;
        this.objHash = objHash;
        this.serverId = serverId;
        this.setText("API Debug");
        this.setImageDescriptor(Images.DEBUG);
    }

    public void run() {
        if (this.win != null) {
            try {
                ApiDebugView view = (ApiDebugView)this.win.getActivePage().showView(ApiDebugView.ID, String.valueOf(this.objHash) + "&" + TimeUtil.getCurrentTime(this.serverId), 1);
                if (view != null) {
                    view.setInput(this.serverId, this.objHash);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

