/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.context.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import scouter.client.net.LoginMgr;
import scouter.client.net.LoginResult;
import scouter.client.popup.LoginDialog2;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.util.StringUtil;

public class OpenServerAction
extends Action {
    public static final String ID = OpenServerAction.class.getName();
    private final int serverId;

    public OpenServerAction(int serverId) {
        super("&Open Server");
        this.serverId = serverId;
    }

    public void run() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (StringUtil.isNotEmpty((String)server.getUserId()) && StringUtil.isNotEmpty((String)server.getPassword())) {
            LoginResult result = LoginMgr.silentLogin(server, server.getUserId(), server.getPassword());
            if (!result.success) {
                ConsoleProxy.errorSafe(result.getErrorMessage());
            }
        } else {
            LoginDialog2 dialog = new LoginDialog2(Display.getDefault().getActiveShell(), null, 993, String.valueOf(server.getIp()) + ":" + server.getPort(), server.getSocksAddr());
            dialog.open();
        }
    }
}

