/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.context.actions;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Images;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;
import scouter.client.util.RCPUtil;

public class RemoveServerAction
extends Action {
    public static final String ID = RemoveServerAction.class.getName();
    private final IWorkbenchWindow window;
    private final int serverId;

    public RemoveServerAction(IWorkbenchWindow window, int serverId) {
        super("&Remove");
        this.window = window;
        this.serverId = serverId;
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.server_delete));
    }

    public void run() {
        if (this.window != null) {
            boolean ok;
            Server newDefault = null;
            if (ServerManager.getInstance().getDefaultServer().getId() == this.serverId) {
                Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerList();
                Integer[] serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
                int i = 0;
                while (i < serverIds.length) {
                    if (this.serverId != serverIds[i]) {
                        newDefault = ServerManager.getInstance().getServer(serverIds[i]);
                        break;
                    }
                    ++i;
                }
            }
            if (ok = MessageDialog.openQuestion((Shell)this.window.getShell(), (String)"Remove Server", (String)("The selected server will disappear on your window. " + (newDefault != null ? "'" + newDefault.getName() + "' will be Default." : "") + " \n\nContinue?"))) {
                Server server = ServerManager.getInstance().getServer(this.serverId);
                ServerPrefUtil.removeServerAddr(String.valueOf(server.getIp()) + ":" + server.getPort());
                ServerManager.getInstance().removeServer(this.serverId);
                if (newDefault != null) {
                    ConsoleProxy.infoSafe("Default Server Changed to '" + newDefault.getName() + "'");
                    ServerManager.getInstance().setDefaultServer(newDefault);
                    ServerPrefUtil.storeDefaultServer(String.valueOf(newDefault.getIp()) + ":" + newDefault.getPort());
                    if (MessageDialog.openConfirm((Shell)this.window.getShell(), (String)"Reset Perspectives", (String)"Default server is changed. Would you reset all perspective?")) {
                        RCPUtil.resetPerspective();
                    }
                }
            }
        }
    }
}

