/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.context.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Activator;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.RCPUtil;

public class SetDefaultServerAction
extends Action {
    public static final String ID = SetDefaultServerAction.class.getName();
    IWorkbenchWindow win;
    Server server;

    public SetDefaultServerAction(IWorkbenchWindow window, Server server) {
        super("Set as Default Server");
        this.win = window;
        this.server = server;
    }

    public void run() {
        if (this.server != null) {
            ServerPrefUtil.storeDefaultServer(String.valueOf(this.server.getIp()) + ":" + this.server.getPort());
            ServerManager.getInstance().setDefaultServer(this.server);
            IWorkbenchPage page = this.win.getActivePage();
            IPerspectiveDescriptor perspective = page.getPerspective();
            if (Activator.getDefault().isPrePerspective(perspective.getId())) {
                if (MessageDialog.openConfirm((Shell)this.win.getShell(), (String)"Reset Perspectives", (String)"Default server is changed. Would you reset current perspective?")) {
                    RCPUtil.resetPerspective();
                }
            } else {
                MessageDialog.openInformation((Shell)this.win.getShell(), (String)"Custom perspective", (String)"Default server is changed. But custom perspective is not applied");
            }
        }
    }
}

