/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.counter.views.CounterPastCountView;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.util.DateUtil;

public class OpenDailyServiceCountAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenDailyServiceCountAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private String counter;
    private int serverId;
    private String date;

    public OpenDailyServiceCountAction(IWorkbenchWindow window, String objType, String counter, Image image, int serverId) {
        this(window, objType, counter, image, serverId, null);
    }

    public OpenDailyServiceCountAction(IWorkbenchWindow window, String objType, String counter, Image image, int serverId, String date) {
        this.window = window;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        this.date = date;
        this.setText("24H Service Count");
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            try {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                CalendarDialog dialog = new CalendarDialog(display, this);
                if (this.date == null) {
                    dialog.show();
                } else {
                    dialog.show(-1, -1, DateUtil.getTime((String)this.date, (String)"yyyyMMdd"));
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(String date) {
        if (this.window != null) {
            try {
                CounterPastCountView v = (CounterPastCountView)this.window.getActivePage().showView(CounterPastCountView.ID, String.valueOf(this.objType) + this.counter + date, 1);
                if (v != null) {
                    v.setInput(date, this.objType, this.counter, this.serverId);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }
}

