/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.counter.views.CounterLoadDateView;
import scouter.client.util.ImageUtil;

public class OpenLoadDateCounterAction
extends Action {
    public static final String ID = OpenLoadDateCounterAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private String counter;
    private String curDate;
    private int objHash;
    private String objName;
    private int serverId;

    public OpenLoadDateCounterAction(IWorkbenchWindow window, String label, String objType, String counter, Image image, String curDate, int objHash, String objName, int serverId) {
        this.window = window;
        this.objType = objType;
        this.counter = counter;
        this.curDate = curDate;
        this.objHash = objHash;
        this.objName = objName;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            try {
                String subid = String.valueOf(this.curDate) + "-" + this.objHash + "-" + this.objType + this.counter;
                CounterLoadDateView v = (CounterLoadDateView)this.window.getActivePage().showView(CounterLoadDateView.ID, subid, 1);
                if (v != null) {
                    try {
                        v.setInput(this.curDate, this.objHash, this.objName, this.objType, this.counter, this.serverId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

