/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.counter.views.CounterPTAllPairChart;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;

public class OpenPTPairAllAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    IWorkbenchWindow window;
    int serverId;
    String objType;
    String counter;

    public OpenPTPairAllAction(IWorkbenchWindow window, String name, int serverId, String objType, String counter) {
        this.window = window;
        this.serverId = serverId;
        this.objType = objType;
        this.counter = counter;
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.calendar));
        this.setText(name);
    }

    public void run() {
        CalendarDialog dialog = new CalendarDialog(this.window.getShell().getDisplay(), this);
        dialog.showWithTime(-1, -1, TimeUtil.getCurrentTime(this.serverId) - 300000L);
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        if (this.window != null) {
            try {
                CounterPTAllPairChart chart = (CounterPTAllPairChart)this.window.getActivePage().showView(CounterPTAllPairChart.ID, String.valueOf(this.serverId) + "&" + this.objType + "&" + this.counter, 1);
                if (chart != null) {
                    chart.setInput(startTime, endTime);
                }
            }
            catch (PartInitException e) {
                ConsoleProxy.errorSafe("Error opening view:" + e.getMessage());
            }
        }
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }
}

