/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.counter.views.CounterLoadCountView;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.util.Hexa32;

public class OpenPastCountViewAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenPastCountViewAction.class.getName();
    private final IWorkbenchWindow win;
    private int objHash;
    private String objType;
    private String date;
    private int serverId;

    public OpenPastCountViewAction(IWorkbenchWindow win, String label, Image image, int objHash, String objType, String date, int serverId) {
        this.win = win;
        this.objHash = objHash;
        this.objType = objType;
        this.serverId = serverId;
        this.date = date;
        this.setText(label);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.win != null) {
            if (this.date == null) {
                CalendarDialog dialog = new CalendarDialog(this.win.getShell().getDisplay(), this);
                dialog.show();
            } else {
                this.goLoadCounteView();
            }
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedOk(String date) {
        this.date = date;
        this.goLoadCounteView();
    }

    @Override
    public void onPressedCancel() {
    }

    private void goLoadCounteView() {
        try {
            CounterLoadCountView view = (CounterLoadCountView)this.win.getActivePage().showView(CounterLoadCountView.ID, String.valueOf(Hexa32.toString32((long)this.objHash)) + "-" + this.objType + "ServiceCount" + "-" + this.date, 1);
            if (view != null) {
                view.setInput(this.date, this.objType, "ServiceCount", this.objHash, this.serverId);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
        }
    }
}

