/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Images;
import scouter.client.group.view.CounterPastDateGroupCountView;
import scouter.client.model.GroupObject;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;

public class OpenPastDateGroupCountViewAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenPastDateGroupCountViewAction.class.getName();
    private final IWorkbenchWindow window;
    private String grpName;
    private String objType;
    private String counter;

    public OpenPastDateGroupCountViewAction(IWorkbenchWindow window, String label, String counter, GroupObject grpObj) {
        this.window = window;
        this.counter = counter;
        this.grpName = grpObj.getName();
        this.objType = grpObj.getObjType();
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.TYPE_SERVICE_COUNT));
    }

    public void run() {
        if (this.window != null) {
            try {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                CalendarDialog dialog = new CalendarDialog(display, this);
                dialog.show();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(String date) {
        if (this.window != null) {
            try {
                this.window.getActivePage().showView(CounterPastDateGroupCountView.ID, String.valueOf(this.grpName) + "&" + this.objType + "&" + this.counter + "&" + date, 1);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }
}

