/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.counter.views.CounterPastLongDateAllView;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.util.DateUtil;

public class OpenPastLongDateAllAction
extends Action {
    public static final String ID = OpenPastLongDateAllAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private String counter;
    private String sDate;
    private String eDate;
    private int serverId;

    public OpenPastLongDateAllAction(IWorkbenchWindow window, String label, String objType, String counter, Image image, String sDate, String eDate, int serverId) {
        this.window = window;
        this.objType = objType;
        this.counter = counter;
        this.sDate = sDate;
        this.eDate = eDate;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.sDate == null && this.eDate == null) {
            long yesterday = TimeUtil.getCurrentTime(this.serverId) - CounterPastLongDateAllView.DatePeriodUnit.A_DAY.getTime();
            this.eDate = this.sDate = DateUtil.format((long)yesterday, (String)"yyyyMMdd");
        }
        if (this.window != null) {
            try {
                CounterPastLongDateAllView v = (CounterPastLongDateAllView)this.window.getActivePage().showView(CounterPastLongDateAllView.ID, String.valueOf(this.objType) + this.counter + TimeUtil.getCurrentTime(this.serverId), 1);
                if (v != null) {
                    v.setInput(this.sDate, this.eDate, this.objType, this.counter, this.serverId);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    public void setStartEndTime(String sDate, String eDate) {
        this.sDate = sDate;
        this.eDate = eDate;
    }
}

