/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.counter.views.CounterPastTimeTotalView;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.util.DateUtil;

public class OpenPastTimeTotalAction
extends Action {
    public static final String ID = OpenPastTimeTotalAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private String counter;
    private long startTime;
    private long endTime;
    private int serverId;

    public OpenPastTimeTotalAction(IWorkbenchWindow window, String label, String objType, String counter, Image image, long startTime, long endTime, int serverId) {
        this.window = window;
        this.objType = objType;
        this.counter = counter;
        this.startTime = startTime;
        this.endTime = endTime;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.startTime <= 0L && this.endTime <= 0L) {
            this.startTime = TimeUtil.getCurrentTime(this.serverId) - CalendarDialog.AfterMinuteUnit.FIVE_MIN.getTime();
            this.endTime = 0L;
            String afterMinute = "5 min";
            CalendarDialog.AfterMinuteUnit m = CalendarDialog.AfterMinuteUnit.fromString(afterMinute);
            if (m != null) {
                this.endTime = this.startTime + m.getTime();
            }
            if (!DateUtil.isSameDay((Date)new Date(this.startTime), (Date)new Date(this.endTime))) {
                this.endTime = DateUtil.getTime((String)(String.valueOf(DateUtil.format((long)this.startTime, (String)"MM/dd/yyyy")) + " 23:59"), (String)"MM/dd/yyyy HH:mm");
            }
        }
        if (this.window != null) {
            try {
                CounterPastTimeTotalView v = (CounterPastTimeTotalView)this.window.getActivePage().showView(CounterPastTimeTotalView.ID, String.valueOf(this.objType) + this.counter + this.startTime + this.endTime + TimeUtil.getCurrentTime(this.serverId), 1);
                if (v != null) {
                    v.setInput(this.startTime, this.endTime, this.objType, this.counter, this.serverId);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("[OpenTotalLoadTimeCounterAction] Error opening view:" + e.getMessage()));
            }
        }
    }

    public void setStartEndTime(long st, long et) {
        this.startTime = st;
        this.endTime = et;
    }
}

