/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.group.view.XLogLoadTimeGroupView;
import scouter.client.model.GroupObject;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;

public class OpenPastTimeTranXGroupViewAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenPastTimeTranXGroupViewAction.class.getName();
    private final IWorkbenchWindow window;
    private String grpName;
    private String objType;

    public OpenPastTimeTranXGroupViewAction(IWorkbenchWindow window, String label, GroupObject grpObj) {
        this.window = window;
        this.grpName = grpObj.getName();
        this.objType = grpObj.getObjType();
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.transrealtime));
    }

    public void run() {
        if (this.window != null) {
            try {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                CalendarDialog dialog = new CalendarDialog(display, this);
                dialog.showWithEndTime();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        try {
            XLogLoadTimeGroupView view = (XLogLoadTimeGroupView)this.window.getActivePage().showView(XLogLoadTimeGroupView.ID, String.valueOf(this.grpName) + "&" + this.objType, 1);
            if (view != null) {
                view.setInput(startTime, endTime);
            }
        }
        catch (PartInitException e) {
            ConsoleProxy.error(e.toString());
        }
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }
}

