/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.counter.views.CounterLoadTimeView;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.util.DateUtil;

public class OpenPastTimeViewAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenPastTimeViewAction.class.getName();
    private final IWorkbenchWindow win;
    private int objHash;
    private String objType;
    private String date;
    private String objName;
    private String counter;
    private int serverId;
    long startTime;
    long endTime;

    public OpenPastTimeViewAction(IWorkbenchWindow win, String label, Image image, int objHash, String objType, String date, String objName, String counter, int serverId) {
        this.win = win;
        this.objHash = objHash;
        this.objType = objType;
        this.date = date;
        this.objName = objName;
        this.counter = counter;
        this.serverId = serverId;
        this.setText(label);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.win != null) {
            if (this.date == null) {
                long current = TimeUtil.getCurrentTime(this.serverId);
                CalendarDialog calDialog = new CalendarDialog(this.win.getShell().getDisplay(), this);
                calDialog.showWithTime(UIUtil.getMousePosition(), current);
            } else {
                long st = DateUtil.getTime((String)(String.valueOf(this.date) + " 00:00"), (String)"yyyyMMdd HH:mm");
                CalendarDialog calDialog = new CalendarDialog(this.win.getShell().getDisplay(), this);
                calDialog.showWithTime(UIUtil.getMousePosition(), st);
            }
        }
    }

    private void goLoadCounteView() {
        try {
            String subid = String.valueOf(this.date) + "-" + this.objHash + "-" + this.objType + this.counter + this.startTime + this.endTime;
            CounterLoadTimeView view = (CounterLoadTimeView)this.win.getActivePage().showView(CounterLoadTimeView.ID, subid, 1);
            if (view != null) {
                view.setInput(this.date, this.startTime, this.endTime, this.objHash, this.objName, this.objType, this.counter, this.serverId);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        this.date = DateUtil.yyyymmdd((long)startTime);
        this.startTime = startTime;
        this.endTime = endTime;
        this.goLoadCounteView();
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }
}

