/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.server.ServerManager;
import scouter.client.util.ImageUtil;
import scouter.client.visitor.views.VisitorRealtimeView;
import scouter.lang.pack.MapPack;

public class OpenUniqueTotalVisitorAction
extends Action {
    public static final String ID = OpenUniqueTotalVisitorAction.class.getName();
    private final IWorkbenchWindow win;
    private String objType;
    private int serverId;

    public OpenUniqueTotalVisitorAction(IWorkbenchWindow win, int serverId, String objType) {
        this.win = win;
        this.objType = objType;
        this.serverId = serverId;
        this.setText("Today Visitor");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.monitor));
    }

    public void run() {
        if (this.win != null) {
            try {
                VisitorRealtimeView view = (VisitorRealtimeView)this.win.getActivePage().showView(VisitorRealtimeView.ID, String.valueOf(this.serverId) + "&" + this.objType, 1);
                if (view != null) {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    String displayObjType = ServerManager.getInstance().getServer(this.serverId).getCounterEngine().getDisplayNameObjectType(this.objType);
                    view.setInput(String.valueOf(displayObjType) + "'s  Visitors", "VISITOR_REALTIME_TOTAL", param);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

