/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.util.ImageUtil;
import scouter.client.visitor.views.VisitorRealtimeView;
import scouter.lang.pack.MapPack;

public class OpenUniqueVisitorAction
extends Action {
    public static final String ID = OpenUniqueVisitorAction.class.getName();
    private final IWorkbenchWindow win;
    private int objHash;
    private int serverId;

    public OpenUniqueVisitorAction(IWorkbenchWindow win, int serverId, int objHash) {
        this.win = win;
        this.objHash = objHash;
        this.serverId = serverId;
        this.setText("Today Visitor");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.monitor));
    }

    public void run() {
        if (this.win != null) {
            try {
                VisitorRealtimeView view = (VisitorRealtimeView)this.win.getActivePage().showView(VisitorRealtimeView.ID, String.valueOf(this.serverId) + "&" + this.objHash, 1);
                if (view != null) {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    String objName = TextProxy.object.getText(this.objHash);
                    view.setInput(String.valueOf(objName) + "'s Today Visitors", "VISITOR_REALTIME", param);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

