/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.util.ImageUtil;
import scouter.client.visitor.views.VisitorLoadView;
import scouter.lang.pack.MapPack;

public class OpenVisitorLoadAction
extends Action {
    public static final String ID = OpenVisitorLoadAction.class.getName();
    private final IWorkbenchWindow win;
    private int objHash;
    private int serverId;
    private String date;

    public OpenVisitorLoadAction(IWorkbenchWindow win, int serverId, String date, int objHash) {
        this.win = win;
        this.objHash = objHash;
        this.serverId = serverId;
        this.date = date;
        this.setText("Load");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.calendar));
    }

    public void run() {
        if (this.win != null) {
            try {
                VisitorLoadView view = (VisitorLoadView)this.win.getActivePage().showView(VisitorLoadView.ID, String.valueOf(this.serverId) + "&" + this.date + "&" + this.objHash, 1);
                if (view != null) {
                    MapPack param = new MapPack();
                    param.put("date", this.date);
                    param.put("objHash", (long)this.objHash);
                    String objName = TextProxy.object.getText(this.objHash);
                    view.setInput(String.valueOf(this.date) + " - " + objName, "VISITOR_LOADDATE", param);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

