/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.server.ServerManager;
import scouter.client.util.ImageUtil;
import scouter.client.visitor.views.VisitorLoadView;
import scouter.lang.pack.MapPack;

public class OpenVisitorTotalLoadAction
extends Action {
    public static final String ID = OpenVisitorTotalLoadAction.class.getName();
    private final IWorkbenchWindow win;
    private String objType;
    private int serverId;
    private String date;

    public OpenVisitorTotalLoadAction(IWorkbenchWindow win, int serverId, String date, String objType) {
        this.win = win;
        this.objType = objType;
        this.serverId = serverId;
        this.date = date;
        this.setText("Load");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.calendar));
    }

    public void run() {
        if (this.win != null) {
            try {
                VisitorLoadView view = (VisitorLoadView)this.win.getActivePage().showView(VisitorLoadView.ID, String.valueOf(this.serverId) + "&" + this.date + "&" + this.objType, 1);
                if (view != null) {
                    MapPack param = new MapPack();
                    param.put("date", this.date);
                    param.put("objType", this.objType);
                    String displayObjType = ServerManager.getInstance().getServer(this.serverId).getCounterEngine().getDisplayNameObjectType(this.objType);
                    view.setInput(String.valueOf(this.date) + " - " + displayObjType, "VISITOR_LOADDATE_TOTAL", param);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

