/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.AgentColorManager;
import scouter.client.model.TextProxy;
import scouter.client.preferences.PManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.views.ScouterViewPart;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public abstract class CounterAllPairPainter
extends ScouterViewPart
implements ObjectSelectManager.IObjectCheckListener {
    public static final String ID = CounterAllPairPainter.class.getName();
    protected XYGraph xyGraph;
    protected Map<Integer, TracePair> dataMap = new HashMap<Integer, TracePair>();
    TracePair nearestTracePair;
    protected FigureCanvas canvas;
    boolean isActive = false;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterAllPairPainter.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterAllPairPainter.this.setContentDescription(CounterAllPairPainter.this.desc);
                    } else {
                        CounterAllPairPainter.this.setContentDescription("");
                    }
                    r = CounterAllPairPainter.this.canvas.getClientArea();
                    CounterAllPairPainter.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CounterAllPairPainter.this.nearestTracePair != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterAllPairPainter.this.nearestTracePair.setLineWidth(width);
                    CounterAllPairPainter.this.nearestTracePair = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterAllPairPainter.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterAllPairPainter.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double max = 0.0;
                double value = 0.0;
                for (int objHash : CounterAllPairPainter.this.dataMap.keySet()) {
                    double distance2;
                    double distance;
                    TracePair tp = CounterAllPairPainter.this.dataMap.get(objHash);
                    Trace t1 = tp.totalTrace;
                    ISample s1 = ScouterUtil.getNearestPoint(t1.getDataProvider(), x);
                    Trace t2 = tp.activeTrace;
                    ISample s2 = ScouterUtil.getNearestPoint(t2.getDataProvider(), x);
                    if (s1 == null || s2 == null) continue;
                    int x1 = CounterAllPairPainter.this.xyGraph.primaryXAxis.getValuePosition(s1.getXValue(), false);
                    int y1 = CounterAllPairPainter.this.xyGraph.primaryYAxis.getValuePosition(s1.getYValue(), false);
                    int x2 = CounterAllPairPainter.this.xyGraph.primaryXAxis.getValuePosition(s2.getXValue(), false);
                    int y2 = CounterAllPairPainter.this.xyGraph.primaryYAxis.getValuePosition(s2.getYValue(), false);
                    double distance1 = ScouterUtil.getPointDistance(e.x, e.y, x1, y1);
                    double d = distance = distance1 > (distance2 = ScouterUtil.getPointDistance(e.x, e.y, x2, y2)) ? distance2 : distance1;
                    if (!(minDistance > distance)) continue;
                    minDistance = distance;
                    CounterAllPairPainter.this.nearestTracePair = tp;
                    time = (long)s1.getXValue();
                    max = s1.getYValue();
                    value = s2.getYValue();
                }
                if (CounterAllPairPainter.this.nearestTracePair != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterAllPairPainter.this.nearestTracePair.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(TextProxy.object.getText(CounterAllPairPainter.this.nearestTracePair.objHash)) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nMax : " + FormatUtil.print((Object)max, (String)"#,###.##") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        ObjectSelectManager.getInstance().addObjectCheckStateListener(this);
    }

    @Override
    public void notifyChangeState() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                for (TracePair tp : CounterAllPairPainter.this.dataMap.values()) {
                    if (ObjectSelectManager.getInstance().isUnselectedObject(tp.objHash)) {
                        tp.setVisible(false);
                        continue;
                    }
                    tp.setVisible(true);
                }
                ExUtil.exec((Composite)CounterAllPairPainter.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        CounterAllPairPainter.this.redraw();
                    }
                });
            }
        });
    }

    protected TracePair getTracePair(String objType, int objHash, int bufferSize) {
        TracePair tp = this.dataMap.get(objHash);
        if (tp == null) {
            tp = new TracePair();
            tp.objHash = objHash;
            CircularBufferDataProvider data1 = new CircularBufferDataProvider(true);
            data1.setBufferSize(bufferSize);
            data1.setCurrentXDataArray(new double[0]);
            data1.setCurrentYDataArray(new double[0]);
            String name = StringUtil.trimToEmpty((String)TextProxy.object.getText(objHash));
            Trace trace1 = new Trace(String.valueOf(name) + "(Max)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data1);
            trace1.setPointStyle(Trace.PointStyle.NONE);
            trace1.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace1.setTraceType(Trace.TraceType.SOLID_LINE);
            trace1.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
            this.xyGraph.addTrace(trace1);
            tp.totalTrace = trace1;
            CircularBufferDataProvider data2 = new CircularBufferDataProvider(true);
            data2.setBufferSize(bufferSize);
            data2.setCurrentXDataArray(new double[0]);
            data2.setCurrentYDataArray(new double[0]);
            Trace trace2 = new Trace(String.valueOf(name) + "(Value)", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data2);
            trace2.setPointStyle(Trace.PointStyle.NONE);
            trace2.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace2.setTraceType(Trace.TraceType.SOLID_LINE);
            trace2.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
            this.xyGraph.addTrace(trace2);
            tp.activeTrace = trace2;
            this.dataMap.put(objHash, tp);
        }
        return tp;
    }

    protected double getMaxValue() {
        Iterator<Integer> objHashs = this.dataMap.keySet().iterator();
        double max = 0.0;
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        while (objHashs.hasNext()) {
            int objHash = objHashs.next();
            CircularBufferDataProvider data = (CircularBufferDataProvider)this.dataMap.get((Object)Integer.valueOf((int)objHash)).totalTrace.getDataProvider();
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getMaxValue(max);
    }

    public void dispose() {
        super.dispose();
        ObjectSelectManager.getInstance().removeObjectCheckStateListener(this);
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    public static class TracePair {
        int objHash;
        Trace totalTrace;
        Trace activeTrace;

        public void setLineWidth(int width) {
            if (this.totalTrace != null) {
                this.totalTrace.setLineWidth(width);
            }
            if (this.activeTrace != null) {
                this.activeTrace.setLineWidth(width);
            }
        }

        public void setVisible(boolean visible) {
            if (this.totalTrace != null) {
                this.totalTrace.setVisible(visible);
            }
            if (this.activeTrace != null) {
                this.activeTrace.setVisible(visible);
            }
        }
    }
}

