/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import scouter.client.model.AgentColorManager;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterLoadCountView
extends ScouterViewPart {
    public static final String ID = CounterLoadCountView.class.getName();
    protected String objType;
    protected String counter;
    protected String date;
    protected int objHash;
    protected int serverId;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void setInput(String date, String objType, String counter, int objHash, int serverId) throws Exception {
        this.date = date;
        this.objHash = objHash;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        String objName = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(date, objHash, serverId));
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        this.desc = "\u24e2" + svrName + " | (Past) [" + objName + "][" + date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8) + "] Past-date " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.trace.setName(objName);
        this.trace.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
        this.setViewTab(objType, counter, serverId);
        new LoadJob("Load_" + counter).schedule();
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterLoadCountView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterLoadCountView.this.setContentDescription(CounterLoadCountView.this.desc);
                    } else {
                        CounterLoadCountView.this.setContentDescription("");
                    }
                    r = CounterLoadCountView.this.canvas.getClientArea();
                    this.lock = false;
                }
                if (CounterLoadCountView.this.xyGraph == null) {
                    return;
                }
                CounterLoadCountView.this.xyGraph.setSize(r.width, r.height);
                CounterLoadCountView.this.trace.setLineWidth(r.width / 30);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(false);
        this.xyGraph.primaryXAxis.setShowMajorGrid(false);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(24);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.xyGraph.primaryXAxis.setRange(0.0, 24.0);
        this.trace = new Trace("temp", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(15);
        this.trace.setTraceType(Trace.TraceType.BAR);
        this.trace.setAreaAlpha(200);
        this.xyGraph.addTrace(this.trace);
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String date:" + this.date + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int objHash:" + this.objHash + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    class LoadJob
    extends Job {
        public LoadJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            MapPack out;
            block7: {
                TcpProxy tcp = TcpProxy.getTcpProxy(CounterLoadCountView.this.serverId);
                out = null;
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("date", CounterLoadCountView.this.date);
                        param.put("objHash", (long)CounterLoadCountView.this.objHash);
                        param.put("counter", CounterLoadCountView.this.counter);
                        out = (MapPack)tcp.getSingle("COUNTER_PAST_DATE", (Pack)param);
                    }
                    catch (Throwable t) {
                        ConsoleProxy.errorSafe(t.toString());
                        TcpProxy.putTcpProxy(tcp);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            final long[] values = new long[24];
            if (out != null) {
                ListValue timeLv = out.getList("time");
                ListValue valueLv = out.getList("value");
                int i = 0;
                while (i < timeLv.size()) {
                    int index;
                    long time = timeLv.getLong(i);
                    int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                    values[n] = values[n] + valueLv.getLong(i);
                    ++i;
                }
            }
            ExUtil.exec((Composite)CounterLoadCountView.this.canvas, new Runnable(){

                @Override
                public void run() {
                    double max = 0.0;
                    ((LoadJob)LoadJob.this).CounterLoadCountView.this.traceDataProvider.clearTrace();
                    int i = 0;
                    while (i < values.length) {
                        ((LoadJob)LoadJob.this).CounterLoadCountView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                        ++i;
                    }
                    max = Math.max(ChartUtil.getMax(((LoadJob)LoadJob.this).CounterLoadCountView.this.traceDataProvider.iterator()), max);
                    if (CounterUtil.isPercentValue(((LoadJob)LoadJob.this).CounterLoadCountView.this.objType, ((LoadJob)LoadJob.this).CounterLoadCountView.this.counter)) {
                        ((LoadJob)LoadJob.this).CounterLoadCountView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    } else {
                        ((LoadJob)LoadJob.this).CounterLoadCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                    CounterLoadCountView.this.redraw();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

