/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.model.AgentColorManager;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.MenuUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;

public class CounterLoadTimeView
extends ScouterViewPart {
    public static final String ID = CounterLoadTimeView.class.getName();
    protected String date;
    protected int objHash;
    protected String objName;
    protected String objType;
    protected String counter;
    protected int serverId;
    private long startTime;
    private long endTime;
    IWorkbenchWindow window;
    protected CircularBufferDataProvider provider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void setInput(String date, long startTime, long endTime, int objHash, String objName, String objType, String counter, int serverId) throws Exception {
        this.date = date;
        this.objHash = objHash;
        this.objName = objName;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        this.startTime = startTime;
        this.endTime = endTime;
        String date2 = String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        this.desc = "\u24e2" + svrName + " | (Pasttime) [" + objName + "][" + date2 + "] " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.setViewTab(objType, counter, serverId);
        if (this.trace != null) {
            this.trace.setName(objName);
            this.trace.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
            ChartUtil.addSolidLine(this.xyGraph, this.provider, AgentColorManager.getInstance().assignColor(objType, objHash));
        }
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objHash, objType, counter);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterLoadTimeView.this.load();
            }
        });
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    public void load() {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        MapPack out = null;
        try {
            MapPack param = new MapPack();
            param.put("date", this.date);
            param.put("objHash", (long)this.objHash);
            param.put("objType", this.objType);
            param.put("counter", this.counter);
            param.put("stime", this.startTime);
            param.put("etime", this.endTime);
            out = (MapPack)tcp.getSingle("COUNTER_PAST_TIME", (Pack)param);
            if (out == null) {
                return;
            }
        }
        catch (Throwable t) {
            ConsoleProxy.errorSafe(t.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        final ListValue time = out.getList("time");
        final ListValue value = out.getList("value");
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterLoadTimeView.this.provider.clearTrace();
                int i = 0;
                while (time != null && i < time.size()) {
                    long tm = CastUtil.clong((Object)time.get(i));
                    double va = CastUtil.cdouble((Object)value.get(i));
                    CounterLoadTimeView.this.provider.addSample(new Sample(tm, va));
                    ++i;
                }
                CounterLoadTimeView.this.xyGraph.primaryXAxis.setRange(CounterLoadTimeView.this.startTime, CounterLoadTimeView.this.endTime);
                if (CounterUtil.isPercentValue(CounterLoadTimeView.this.objType, CounterLoadTimeView.this.counter)) {
                    CounterLoadTimeView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterLoadTimeView.this.xyGraph.primaryYAxis.setRange(0.0, ChartUtil.getMax(CounterLoadTimeView.this.provider.iterator()));
                }
                CounterLoadTimeView.this.canvas.redraw();
                CounterLoadTimeView.this.xyGraph.repaint();
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterLoadTimeView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterLoadTimeView.this.setContentDescription(CounterLoadTimeView.this.desc);
                    } else {
                        CounterLoadTimeView.this.setContentDescription("");
                    }
                    r = CounterLoadTimeView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterLoadTimeView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.provider = new CircularBufferDataProvider(true);
        this.provider.setBufferSize(7200);
        this.provider.setCurrentXDataArray(new double[0]);
        this.provider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.provider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("HH:mm");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.SOLID_LINE);
        this.trace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.addTrace(this.trace);
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String date:" + this.date + ", int objHash:" + this.objHash + ", String objName:" + this.objName + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
    }
}

