/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.counter.actions.OpenPTPairAllAction;
import scouter.client.counter.views.CounterAllPairPainter;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.io.DataInputX;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterPTAllPairChart
extends CounterAllPairPainter {
    public static final String ID = CounterPTAllPairChart.class.getName();
    private int serverId;
    private String objType;
    private String counter;
    private long stime;
    private long etime;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new OpenPTPairAllAction(this.getViewSite().getWorkbenchWindow(), "Load", this.serverId, this.objType, this.counter));
    }

    public void setInput(long stime, long etime) {
        this.stime = stime;
        this.etime = etime;
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
            Server server = ServerManager.getInstance().getServer(this.serverId);
            CounterEngine ce = server.getCounterEngine();
            String counterName = ce.getCounterDisplayName(this.objType, this.counter);
            this.desc = "\u24e2" + server.getName() + " | (Past All) " + counterName + "(" + ce.getCounterUnit(this.objType, this.counter) + ") " + DateUtil.format((long)stime, (String)"yyyyMMdd HH:mm:ss") + " ~ " + DateUtil.format((long)etime, (String)"HH:mm:ss");
            this.xyGraph.primaryXAxis.setRange(stime, etime);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Set keySet = this.dataMap.keySet();
        for (Integer key : keySet) {
            CounterAllPairPainter.TracePair tp = (CounterAllPairPainter.TracePair)this.dataMap.get(key);
            this.xyGraph.removeTrace(tp.totalTrace);
            this.xyGraph.removeTrace(tp.activeTrace);
        }
        this.dataMap.clear();
        this.load();
    }

    private void load() {
        CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        new Job("Load " + counterEngine.getCounterDisplayName(this.objType, this.counter)){

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList values;
                block5: {
                    values = new ArrayList();
                    TcpProxy tcp = TcpProxy.getTcpProxy(CounterPTAllPairChart.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("stime", CounterPTAllPairChart.this.stime);
                            param.put("etime", CounterPTAllPairChart.this.etime);
                            param.put("objType", CounterPTAllPairChart.this.objType);
                            param.put("counter", CounterPTAllPairChart.this.counter);
                            tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    MapPack mpack = (MapPack)in.readPack();
                                    values.add(mpack);
                                }
                            });
                        }
                        catch (Throwable t) {
                            ConsoleProxy.errorSafe(t.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)CounterPTAllPairChart.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        double max = 0.0;
                        for (MapPack mpack : values) {
                            int objHash = mpack.getInt("objHash");
                            ListValue time = mpack.getList("time");
                            ListValue value = mpack.getList("value");
                            CounterAllPairPainter.TracePair tp = CounterPTAllPairChart.this.getTracePair((this).CounterPTAllPairChart.this.objType, objHash, (int)(((this).CounterPTAllPairChart.this.etime - (this).CounterPTAllPairChart.this.stime) / 2000L));
                            CircularBufferDataProvider maxProvider = (CircularBufferDataProvider)tp.totalTrace.getDataProvider();
                            CircularBufferDataProvider valueProvider = (CircularBufferDataProvider)tp.activeTrace.getDataProvider();
                            maxProvider.clearTrace();
                            valueProvider.clearTrace();
                            int i = 0;
                            while (time != null && i < time.size()) {
                                long x = time.getLong(i);
                                Value v = value.get(i);
                                if (v != null && v.getValueType() == 70) {
                                    ListValue lv = (ListValue)v;
                                    maxProvider.addSample(new Sample(x, lv.getDouble(0)));
                                    valueProvider.addSample(new Sample(x, lv.getDouble(1)));
                                }
                                ++i;
                            }
                            max = Math.max(ChartUtil.getMax(maxProvider.iterator()), max);
                        }
                        if (CounterUtil.isPercentValue((this).CounterPTAllPairChart.this.objType, (this).CounterPTAllPairChart.this.counter)) {
                            (this).CounterPTAllPairChart.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                        } else {
                            (this).CounterPTAllPairChart.this.xyGraph.primaryYAxis.setRange(0.0, max);
                        }
                        CounterPTAllPairChart.this.redraw();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

