/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.counter.actions.OpenPTPairAllAction2;
import scouter.client.counter.views.CounterAllPairPainter;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.io.DataInputX;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterPTAllPairChart2
extends CounterAllPairPainter {
    public static final String ID = CounterPTAllPairChart2.class.getName();
    private int serverId;
    private String objType;
    private String counter1;
    private String counter2;
    private long stime;
    private long etime;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter1 = ids[2];
        this.counter2 = ids[3];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new OpenPTPairAllAction2(this.getViewSite().getWorkbenchWindow(), "Load", this.serverId, this.objType, this.counter1, this.counter2));
    }

    public void setInput(long stime, long etime) {
        this.stime = stime;
        this.etime = etime;
        try {
            this.setViewTab(this.objType, this.counter1, this.serverId);
            Server server = ServerManager.getInstance().getServer(this.serverId);
            CounterEngine ce = server.getCounterEngine();
            String counterName = ce.getCounterDisplayName(this.objType, this.counter1);
            this.desc = "\u24e2" + server.getName() + " | (Past All) " + counterName + "(" + ce.getCounterUnit(this.objType, this.counter1) + ") " + DateUtil.format((long)stime, (String)"yyyyMMdd HH:mm:ss") + " ~ " + DateUtil.format((long)etime, (String)"HH:mm:ss");
            this.xyGraph.primaryXAxis.setRange(stime, etime);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Set keySet = this.dataMap.keySet();
        for (Integer key : keySet) {
            CounterAllPairPainter.TracePair tp = (CounterAllPairPainter.TracePair)this.dataMap.get(key);
            this.xyGraph.removeTrace(tp.totalTrace);
            this.xyGraph.removeTrace(tp.activeTrace);
        }
        this.dataMap.clear();
        this.load();
    }

    private void load() {
        CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        new Job("Load " + counterEngine.getCounterDisplayName(this.objType, this.counter1)){

            protected IStatus run(IProgressMonitor monitor) {
                HashMap valueMap2;
                HashMap valueMap1;
                block5: {
                    valueMap1 = new HashMap();
                    valueMap2 = new HashMap();
                    TcpProxy tcp = TcpProxy.getTcpProxy(CounterPTAllPairChart2.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("stime", CounterPTAllPairChart2.this.stime);
                            param.put("etime", CounterPTAllPairChart2.this.etime);
                            param.put("objType", CounterPTAllPairChart2.this.objType);
                            param.put("counter", CounterPTAllPairChart2.this.counter1);
                            tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    MapPack mpack = (MapPack)in.readPack();
                                    int objHash = mpack.getInt("objHash");
                                    valueMap1.put(objHash, mpack);
                                }
                            });
                            param.put("counter", CounterPTAllPairChart2.this.counter2);
                            tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    MapPack mpack = (MapPack)in.readPack();
                                    int objHash = mpack.getInt("objHash");
                                    valueMap2.put(objHash, mpack);
                                }
                            });
                        }
                        catch (Throwable t) {
                            ConsoleProxy.errorSafe(t.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)CounterPTAllPairChart2.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        double max = 0.0;
                        for (MapPack mpack : valueMap1.values()) {
                            try {
                                int objHash = mpack.getInt("objHash");
                                ListValue time = mpack.getList("time");
                                ListValue value1 = mpack.getList("value");
                                ListValue value2 = ((MapPack)valueMap2.get(objHash)).getList("value");
                                CounterAllPairPainter.TracePair tp = CounterPTAllPairChart2.this.getTracePair((this).CounterPTAllPairChart2.this.objType, objHash, (int)(((this).CounterPTAllPairChart2.this.etime - (this).CounterPTAllPairChart2.this.stime) / 2000L));
                                CircularBufferDataProvider maxProvider = (CircularBufferDataProvider)tp.totalTrace.getDataProvider();
                                CircularBufferDataProvider valueProvider = (CircularBufferDataProvider)tp.activeTrace.getDataProvider();
                                maxProvider.clearTrace();
                                valueProvider.clearTrace();
                                int i = 0;
                                while (time != null && i < time.size()) {
                                    long x = time.getLong(i);
                                    maxProvider.addSample(new Sample(x, CastUtil.cdouble((Object)value1.get(i))));
                                    valueProvider.addSample(new Sample(x, CastUtil.cdouble((Object)value2.get(i))));
                                    ++i;
                                }
                                max = Math.max(ChartUtil.getMax(maxProvider.iterator()), max);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (CounterUtil.isPercentValue((this).CounterPTAllPairChart2.this.objType, (this).CounterPTAllPairChart2.this.counter1)) {
                            (this).CounterPTAllPairChart2.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                        } else {
                            (this).CounterPTAllPairChart2.this.xyGraph.primaryYAxis.setRange(0.0, max);
                        }
                        CounterPTAllPairChart2.this.redraw();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

