/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.List;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenDailyServiceCountAction;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class CounterPastCountView
extends ScouterViewPart {
    public static final String ID = CounterPastCountView.class.getName();
    protected String objType;
    protected String counter;
    protected String date;
    private String mode;
    protected int serverId;
    int xAxisUnitWidth;
    int lineWidth;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void setInput(final String date, final String objType, final String counter, final int serverId) throws Exception {
        this.date = date;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String objectDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            objectDisplay = server.getCounterEngine().getDisplayNameObjectType(objType);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        this.desc = "\u24e2" + svrName + " | (Past) [" + objectDisplay + "][" + date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8) + "] Past-date " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.setViewTab(objType, counter, serverId);
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        final IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)new OpenDailyServiceCountAction(win, objType, counter, Images.bar, serverId, date));
            }
        });
        Menu menu = mgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
        new LoadJob("Load_" + counter).schedule();
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastCountView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastCountView.this.setContentDescription(CounterPastCountView.this.desc);
                    } else {
                        CounterPastCountView.this.setContentDescription("");
                    }
                    r = CounterPastCountView.this.canvas.getClientArea();
                    this.lock = false;
                }
                if (CounterPastCountView.this.xyGraph == null) {
                    return;
                }
                CounterPastCountView.this.xyGraph.setSize(r.width, r.height);
                CounterPastCountView.this.lineWidth = r.width / 30;
                CounterPastCountView.this.trace.setLineWidth(CounterPastCountView.this.lineWidth);
                CounterPastCountView.this.xAxisUnitWidth = CounterPastCountView.this.xyGraph.primaryXAxis.getValuePosition(1.0, false) - CounterPastCountView.this.xyGraph.primaryXAxis.getValuePosition(0.0, false);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                CounterPastCountView.this.canvas.redraw();
            }

            public void mouseDown(MouseEvent e) {
                CounterPastCountView.this.writeValue(e.x);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(false);
        this.xyGraph.primaryXAxis.setShowMajorGrid(false);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(24);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.xyGraph.primaryXAxis.setRange(0.0, 24.0);
        this.trace = new Trace("temp", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(15);
        this.trace.setTraceType(Trace.TraceType.BAR);
        this.trace.setAreaAlpha(200);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(this.trace);
    }

    public void writeValue(int ex) {
        double x = this.xyGraph.primaryXAxis.getPositionValue(ex, false);
        int index = (int)x;
        if (index < 0) {
            return;
        }
        Sample sample = (Sample)this.trace.getDataProvider().getSample(index);
        if (sample != null) {
            double y = sample.getYValue();
            int height = this.xyGraph.primaryYAxis.getValuePosition(y, false);
            int startX = this.xyGraph.primaryXAxis.getValuePosition((int)x, false);
            GC gc = new GC((Drawable)this.canvas);
            Font font = new Font(null, "Verdana", 10, 1);
            gc.setFont(font);
            String value = FormatUtil.print((Object)y, (String)"#,###");
            Point textSize = gc.textExtent(value);
            gc.drawText(value, startX + (this.xAxisUnitWidth - textSize.x) / 2, height - 20, true);
            int ground = this.xyGraph.primaryYAxis.getValuePosition(0.0, false);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(12));
            gc.drawRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.fillRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.dispose();
        }
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String date:" + this.date + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    class LoadJob
    extends Job {
        public LoadJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            List<Pack> out;
            block7: {
                TcpProxy tcp = TcpProxy.getTcpProxy(CounterPastCountView.this.serverId);
                out = null;
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("date", CounterPastCountView.this.date);
                        param.put("counter", CounterPastCountView.this.counter);
                        param.put("objType", CounterPastCountView.this.objType);
                        out = tcp.process("COUNTER_PAST_DATE_ALL", (Pack)param);
                    }
                    catch (Throwable t) {
                        ConsoleProxy.errorSafe(t.toString());
                        TcpProxy.putTcpProxy(tcp);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            final long[] values = new long[24];
            if (out != null) {
                Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(CounterPastCountView.this.counter, out, CounterPastCountView.this.mode, (byte)3);
                for (long time : valueMap.keySet()) {
                    int index;
                    int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                    values[n] = (long)((double)values[n] + valueMap.get(time));
                }
            }
            ExUtil.exec((Composite)CounterPastCountView.this.canvas, new Runnable(){

                @Override
                public void run() {
                    double max = 0.0;
                    ((LoadJob)LoadJob.this).CounterPastCountView.this.traceDataProvider.clearTrace();
                    int i = 0;
                    while (i < values.length) {
                        ((LoadJob)LoadJob.this).CounterPastCountView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                        ++i;
                    }
                    max = Math.max(ChartUtil.getMax(((LoadJob)LoadJob.this).CounterPastCountView.this.traceDataProvider.iterator()), max);
                    if (CounterUtil.isPercentValue(((LoadJob)LoadJob.this).CounterPastCountView.this.objType, ((LoadJob)LoadJob.this).CounterPastCountView.this.counter)) {
                        ((LoadJob)LoadJob.this).CounterPastCountView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    } else {
                        ((LoadJob)LoadJob.this).CounterPastCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                    CounterPastCountView.this.redraw();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

