/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenPastLongDateAllAction;
import scouter.client.model.AgentColorManager;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.DualCalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.TimedSeries;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CounterPastLongDateAllView
extends ScouterViewPart
implements DualCalendarDialog.ILoadDualCounterDialog {
    public static final String ID = CounterPastLongDateAllView.class.getName();
    protected String objType;
    protected String counter;
    protected int serverId;
    protected String sDate;
    protected String eDate;
    Label serverText;
    Label sDateText;
    Label eDateText;
    DualCalendarDialog calDialog;
    Combo periodCombo;
    Composite headerComp;
    Button applyBtn;
    Trace nearestTrace;
    IWorkbenchWindow window;
    IToolBarManager man;
    int buffer = 0;
    private long stime;
    private long etime;
    boolean actionReg = false;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    private int leftMargin = 0;
    private Composite marginTargetComposite;
    private Map<Integer, Trace> traces = new HashMap<Integer, Trace>();

    public String getCount() {
        return this.counter;
    }

    public void setInput(String sDate, String eDate, String objType, String counter, int serverId) throws Exception {
        this.sDate = sDate;
        this.eDate = eDate;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        this.setViewTab(objType, counter, serverId, false);
        this.stime = DateUtil.getTime((String)sDate, (String)"yyyyMMdd");
        this.etime = DateUtil.getTime((String)eDate, (String)"yyyyMMdd") + 86400000L;
        this.xyGraph.primaryXAxis.setRange(this.stime, this.etime);
        Server server = ServerManager.getInstance().getServer(serverId);
        String counterUnit = "";
        String counterDisplay = "";
        if (server != null) {
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            this.desc = "(Daily All) [" + sDate.substring(0, 4) + "-" + sDate.substring(4, 6) + "-" + sDate.substring(6, 8) + " ~ " + eDate.substring(0, 4) + "-" + eDate.substring(4, 6) + "-" + eDate.substring(6, 8) + "]" + counterDisplay;
        }
        this.serverText.setText("\u24e2" + (server == null ? "?" : server.getName()) + " |" + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : ""));
        this.sDateText.setText(DateUtil.format((long)this.stime, (String)"yyyy-MM-dd"));
        this.eDateText.setText(DateUtil.format((long)(this.etime - 1L), (String)"yyyy-MM-dd"));
        this.buffer = (int)((this.etime - this.stime) / 300000L);
        for (Trace tr : this.traces.values()) {
            this.xyGraph.removeTrace(tr);
        }
        this.traces.clear();
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objType, counter, this.stime, this.etime);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastLongDateAllView.this.load(CounterPastLongDateAllView.this.sDate, CounterPastLongDateAllView.this.eDate, CounterPastLongDateAllView.this.counter);
            }
        });
    }

    private void load(String sDate, String eDate, final String counter) {
        ArrayList values;
        block5: {
            values = new ArrayList();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("sDate", sDate);
                    param.put("eDate", eDate);
                    param.put("objType", this.objType);
                    param.put("counter", counter);
                    tcp.process("COUNTER_PAST_LONGDATE_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack mpack = (MapPack)in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                double max = 0.0;
                for (MapPack mpack : values) {
                    int objHash = mpack.getInt("objHash");
                    ListValue time = mpack.getList("time");
                    ListValue value = mpack.getList("value");
                    Trace trace = CounterPastLongDateAllView.this.intern(objHash);
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)trace.getDataProvider();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        long x = time.getLong(i);
                        double y = value.getDouble(i);
                        provider.addSample(new Sample(x, y));
                        ++i;
                    }
                    max = Math.max(ChartUtil.getMax(provider.iterator()), max);
                }
                if (CounterUtil.isPercentValue(CounterPastLongDateAllView.this.objType, counter)) {
                    CounterPastLongDateAllView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterPastLongDateAllView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastLongDateAllView.this.redraw();
                CounterPastLongDateAllView.this.applyBtn.setEnabled(true);
            }
        });
    }

    private void duplicateView() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String counterDisplay = "";
        if (server != null) {
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        }
        OpenPastLongDateAllAction duplicateAction = new OpenPastLongDateAllAction(this.window, counterDisplay, this.objType, this.counter, Images.getCounterImage(this.objType, this.counter, this.serverId), this.sDate, this.eDate, this.serverId);
        duplicateAction.run();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.marginTargetComposite = chartComposite;
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, this.leftMargin, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastLongDateAllView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowLegendAllowSize(r.width, r.height)) {
                        CounterPastLongDateAllView.this.xyGraph.setShowLegend(true);
                    } else {
                        CounterPastLongDateAllView.this.xyGraph.setShowLegend(false);
                    }
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastLongDateAllView.this.setContentDescription(CounterPastLongDateAllView.this.desc);
                    } else {
                        CounterPastLongDateAllView.this.setContentDescription("");
                    }
                    r = CounterPastLongDateAllView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterPastLongDateAllView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CounterPastLongDateAllView.this.nearestTrace != null) {
                    CounterPastLongDateAllView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CounterPastLongDateAllView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterPastLongDateAllView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterPastLongDateAllView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CounterPastLongDateAllView.this.traces.values()) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CounterPastLongDateAllView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CounterPastLongDateAllView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CounterPastLongDateAllView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CounterPastLongDateAllView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterPastLongDateAllView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CounterPastLongDateAllView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CounterPastLongDateAllView.this.setInput((this).CounterPastLongDateAllView.this.sDate, (this).CounterPastLongDateAllView.this.eDate, (this).CounterPastLongDateAllView.this.objType, (this).CounterPastLongDateAllView.this.counter, (this).CounterPastLongDateAllView.this.serverId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CounterPastLongDateAllView.this.setInput((this).CounterPastLongDateAllView.this.sDate, (this).CounterPastLongDateAllView.this.eDate, (this).CounterPastLongDateAllView.this.objType, (this).CounterPastLongDateAllView.this.counter, (this).CounterPastLongDateAllView.this.serverId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.man.add((IContributionItem)new Separator());
        this.man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        CounterPastLongDateAllView.this.duplicateView();
                    }
                });
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)new Action("Export CSV", ImageUtil.getImageDescriptor(Images.csv)){

            public void run() {
                FileDialog dialog = new FileDialog(CounterPastLongDateAllView.this.getViewSite().getShell(), 8192);
                dialog.setOverwrite(true);
                String filename = "[" + DateUtil.format((long)CounterPastLongDateAllView.this.stime, (String)"yyyyMMdd") + "-" + DateUtil.format((long)(CounterPastLongDateAllView.this.etime - 1L), (String)"yyyyMMdd") + "]" + CounterPastLongDateAllView.this.objType + "_" + CounterPastLongDateAllView.this.counter + ".csv";
                dialog.setFileName(filename);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV File(*.csv)", "All Files"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    new ExportDataTask(fileSelected).schedule();
                }
            }
        });
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        long initialTime = TimeUtil.getCurrentTime(this.serverId) - DatePeriodUnit.A_DAY.getTime();
        this.applyBtn = new Button(this.headerComp, 8);
        this.applyBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.applyBtn.setText("Apply");
        this.applyBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ((Button)event.widget).setEnabled(false);
                        try {
                            CounterPastLongDateAllView.this.setInput(CounterPastLongDateAllView.this.sDate, CounterPastLongDateAllView.this.eDate, CounterPastLongDateAllView.this.objType, CounterPastLongDateAllView.this.counter, CounterPastLongDateAllView.this.serverId);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.applyBtn, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastLongDateAllView.this.calDialog = new DualCalendarDialog(display, CounterPastLongDateAllView.this);
                        CounterPastLongDateAllView.this.calDialog.show(UIUtil.getMousePosition());
                    }
                }
            }
        });
        this.periodCombo = new Combo(this.headerComp, 2568);
        this.periodCombo.setLayoutData((Object)UIUtil.formData(null, -1, 0, 3, manualBtn, -5, null, -1));
        ArrayList<String> periodStrList = new ArrayList<String>();
        DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
        int n = datePeriodUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatePeriodUnit minute = datePeriodUnitArray[n2];
            periodStrList.add(minute.getLabel());
            ++n2;
        }
        this.periodCombo.setItems(periodStrList.toArray(new String[DatePeriodUnit.values().length]));
        this.periodCombo.select(2);
        this.periodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Combo)e.widget).getSelectionIndex() == 0) {
                    this.setStartEndDate(30);
                } else if (((Combo)e.widget).getSelectionIndex() == 1) {
                    this.setStartEndDate(7);
                } else {
                    this.setStartEndDate(1);
                }
            }

            private void setStartEndDate(int i) {
                long yesterday = TimeUtil.getCurrentTime(CounterPastLongDateAllView.this.serverId) - DatePeriodUnit.A_DAY.getTime();
                long startDate = TimeUtil.getCurrentTime(CounterPastLongDateAllView.this.serverId) - DatePeriodUnit.A_DAY.getTime() * (long)i;
                CounterPastLongDateAllView.this.sDateText.setText(DateUtil.format((long)startDate, (String)"yyyy-MM-dd"));
                CounterPastLongDateAllView.this.eDateText.setText(DateUtil.format((long)yesterday, (String)"yyyy-MM-dd"));
                CounterPastLongDateAllView.this.sDate = DateUtil.format((long)startDate, (String)"yyyyMMdd");
                CounterPastLongDateAllView.this.eDate = DateUtil.format((long)yesterday, (String)"yyyyMMdd");
                CounterPastLongDateAllView.this.stime = DateUtil.getTime((String)CounterPastLongDateAllView.this.sDate, (String)"yyyyMMdd");
                CounterPastLongDateAllView.this.etime = DateUtil.getTime((String)CounterPastLongDateAllView.this.eDate, (String)"yyyyMMdd") + 86400000L;
            }
        });
        this.eDateText = new Label(this.headerComp, 0);
        this.eDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.periodCombo, -5, null, -1));
        this.eDateText.setText(DateUtil.format((long)(initialTime - 1L), (String)"yyyy-MM-dd"));
        Label windbarLabel = new Label(this.headerComp, 0);
        windbarLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.eDateText, -5, null, -1));
        windbarLabel.setText("~");
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, windbarLabel, -5, null, -1));
        this.sDateText.setText(DateUtil.format((long)initialTime, (String)"yyyy-MM-dd"));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.serverText.setText("\u24e2");
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String sDate:" + this.sDate + ", String eDate:" + this.eDate + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    private synchronized Trace intern(int objHash) {
        Trace trace = this.traces.get(objHash);
        if (trace != null) {
            return trace;
        }
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(true);
        traceDataProvider.setBufferSize(this.buffer);
        traceDataProvider.setCurrentXDataArray(new double[0]);
        traceDataProvider.setCurrentYDataArray(new double[0]);
        String name = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(this.sDate, objHash, this.serverId));
        trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.NONE);
        trace.getXAxis().setTitle("");
        trace.getYAxis().setTitle("");
        trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        trace.getXAxis().setFormatPattern("yyyy-MM-dd\n  HH:mm:ss");
        trace.getYAxis().setFormatPattern("#,##0");
        trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, objHash));
        this.xyGraph.addTrace(trace);
        this.traces.put(objHash, trace);
        return trace;
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void onPressedOk(String sDate, String eDate) {
        try {
            this.setInput(sDate, eDate, this.objType, this.counter, this.serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum DatePeriodUnit {
        A_MONTH("1 Month", -1702967296L),
        A_WEEK("1 Week", 604800000L),
        A_DAY("1 Day", 86400000L);

        private String label;
        private long time;

        private DatePeriodUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static DatePeriodUnit fromString(String text) {
            if (text != null) {
                DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
                int n = datePeriodUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DatePeriodUnit b = datePeriodUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    class ExportDataTask
    extends Job {
        String filePath;

        public ExportDataTask(String filePath) {
            super("Export...");
            this.filePath = filePath;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                TimedSeries<String, Double> sereis = new TimedSeries<String, Double>();
                Range xRange = CounterPastLongDateAllView.this.xyGraph.primaryXAxis.getRange();
                long lower = (long)xRange.getLower();
                long upper = (long)xRange.getUpper();
                List<Trace> traceList = CounterPastLongDateAllView.this.xyGraph.getPlotArea().getTraceList();
                ArrayList<String> titleValues = new ArrayList<String>();
                titleValues.add("Time");
                for (Trace t : traceList) {
                    titleValues.add(t.getName());
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)t.getDataProvider();
                    int inx = 0;
                    while (inx < provider.getSize()) {
                        Sample sample = (Sample)provider.getSample(inx);
                        double x = sample.getXValue();
                        if (!(x < (double)lower) && !(x > (double)upper)) {
                            double y = sample.getYValue();
                            sereis.add(t.getName(), (long)x, y);
                        }
                        ++inx;
                    }
                }
                ArrayList<String[]> values = new ArrayList<String[]>();
                values.add(titleValues.toArray(new String[titleValues.size()]));
                while (lower < upper) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(DateUtil.format((long)lower, (String)"yyyy-MM-dd HH:mm"));
                    int i = 1;
                    while (i < titleValues.size()) {
                        String objName = (String)titleValues.get(i);
                        Double d = (Double)sereis.getInTime(objName, lower, 299999L);
                        if (d != null) {
                            value.add(FormatUtil.print((Object)d, (String)"#,###.##"));
                        } else {
                            value.add("");
                        }
                        ++i;
                    }
                    values.add(value.toArray(new String[value.size()]));
                    lower += 300000L;
                }
                CSVWriter cw = new CSVWriter((Writer)new FileWriter(this.filePath));
                cw.writeAll(values);
                cw.flush();
                cw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

