/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenPastLongDateTotalAction;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.DualCalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CounterPastLongDateTotalView
extends ScouterViewPart
implements DualCalendarDialog.ILoadDualCounterDialog {
    public static final String ID = CounterPastLongDateTotalView.class.getName();
    protected String objType;
    protected String counter;
    private String mode;
    protected int serverId;
    protected String sDate;
    protected String eDate;
    Label serverText;
    Label sDateText;
    Label eDateText;
    DualCalendarDialog calDialog;
    Combo periodCombo;
    Composite headerComp;
    Button applyBtn;
    IWorkbenchWindow window;
    IToolBarManager man;
    int buffer = 0;
    private long stime;
    private long etime;
    boolean actionReg = false;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;
    private int leftMargin = 0;
    private Composite marginTargetComposite;

    public void setInput(String sDate, String eDate, String objType, String counter, int serverId) throws Exception {
        this.sDate = sDate;
        this.eDate = eDate;
        this.objType = objType;
        this.counter = counter;
        this.mode = CounterUtil.getTotalMode(objType, counter);
        this.serverId = serverId;
        this.setViewTab(objType, counter, serverId, false);
        Server server = ServerManager.getInstance().getServer(serverId);
        String counterUnit = "";
        String counterDisplay = "";
        if (server != null) {
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            this.desc = "(Period) [" + sDate.substring(0, 4) + "-" + sDate.substring(4, 6) + "-" + sDate.substring(6, 8) + " ~ " + eDate.substring(0, 4) + "-" + eDate.substring(4, 6) + "-" + eDate.substring(6, 8) + "] Total " + counterDisplay;
        }
        this.serverText.setText("\u24e2" + (server == null ? "?" : server.getName()) + " |" + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : ""));
        this.stime = DateUtil.getTime((String)sDate, (String)"yyyyMMdd");
        this.etime = DateUtil.getTime((String)eDate, (String)"yyyyMMdd") + 86400000L;
        this.xyGraph.primaryXAxis.setRange(this.stime, this.etime);
        this.sDateText.setText(DateUtil.format((long)this.stime, (String)"yyyy-MM-dd"));
        this.eDateText.setText(DateUtil.format((long)(this.etime - 1L), (String)"yyyy-MM-dd"));
        this.buffer = (int)((this.etime - this.stime) / 300000L);
        this.traceDataProvider.setBufferSize(this.buffer);
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objType, counter, this.stime, this.etime);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastLongDateTotalView.this.load();
            }
        });
    }

    private void load() {
        ArrayList<Pack> values;
        block5: {
            values = new ArrayList<Pack>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("sDate", this.sDate);
                    param.put("eDate", this.eDate);
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_PAST_LONGDATE_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack pack = in.readPack();
                            values.add(pack);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, values, this.mode, (byte)3);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                try {
                    CounterPastLongDateTotalView.this.traceDataProvider.clearTrace();
                    Set timeSet = valueMap.keySet();
                    Iterator iterator = timeSet.iterator();
                    while (iterator.hasNext()) {
                        long time = (Long)iterator.next();
                        CounterPastLongDateTotalView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)time), CastUtil.cdouble(valueMap.get(time))));
                    }
                }
                catch (Throwable t) {
                    ConsoleProxy.error(t.toString());
                }
                if (CounterUtil.isPercentValue(CounterPastLongDateTotalView.this.objType, CounterPastLongDateTotalView.this.counter)) {
                    CounterPastLongDateTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(CounterPastLongDateTotalView.this.traceDataProvider.iterator());
                    CounterPastLongDateTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastLongDateTotalView.this.redraw();
                CounterPastLongDateTotalView.this.applyBtn.setEnabled(true);
            }
        });
    }

    private void duplicateView() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String counterDisplay = "";
        if (server != null) {
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        }
        OpenPastLongDateTotalAction duplicateAction = new OpenPastLongDateTotalAction(this.window, counterDisplay, this.objType, this.counter, Images.getCounterImage(this.objType, this.counter, this.serverId), this.sDate, this.eDate, this.serverId);
        duplicateAction.run();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.marginTargetComposite = chartComposite;
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, this.leftMargin, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastLongDateTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastLongDateTotalView.this.setContentDescription(CounterPastLongDateTotalView.this.desc);
                    } else {
                        CounterPastLongDateTotalView.this.setContentDescription("");
                    }
                    r = CounterPastLongDateTotalView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterPastLongDateTotalView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("yyyy-MM-dd\n  HH:mm:ss");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CounterPastLongDateTotalView.this.setInput((this).CounterPastLongDateTotalView.this.sDate, (this).CounterPastLongDateTotalView.this.eDate, (this).CounterPastLongDateTotalView.this.objType, (this).CounterPastLongDateTotalView.this.counter, (this).CounterPastLongDateTotalView.this.serverId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CounterPastLongDateTotalView.this.setInput((this).CounterPastLongDateTotalView.this.sDate, (this).CounterPastLongDateTotalView.this.eDate, (this).CounterPastLongDateTotalView.this.objType, (this).CounterPastLongDateTotalView.this.counter, (this).CounterPastLongDateTotalView.this.serverId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.man.add((IContributionItem)new Separator());
        this.man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        CounterPastLongDateTotalView.this.duplicateView();
                    }
                });
            }
        });
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        long initialTime = TimeUtil.getCurrentTime(this.serverId) - DatePeriodUnit.A_DAY.getTime();
        this.applyBtn = new Button(this.headerComp, 8);
        this.applyBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.applyBtn.setText("Apply");
        this.applyBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ((Button)event.widget).setEnabled(false);
                        try {
                            CounterPastLongDateTotalView.this.setInput(CounterPastLongDateTotalView.this.sDate, CounterPastLongDateTotalView.this.eDate, CounterPastLongDateTotalView.this.objType, CounterPastLongDateTotalView.this.counter, CounterPastLongDateTotalView.this.serverId);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.applyBtn, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastLongDateTotalView.this.calDialog = new DualCalendarDialog(display, CounterPastLongDateTotalView.this);
                        CounterPastLongDateTotalView.this.calDialog.show(UIUtil.getMousePosition());
                    }
                }
            }
        });
        this.periodCombo = new Combo(this.headerComp, 2568);
        this.periodCombo.setLayoutData((Object)UIUtil.formData(null, -1, 0, 3, manualBtn, -5, null, -1));
        ArrayList<String> periodStrList = new ArrayList<String>();
        DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
        int n = datePeriodUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatePeriodUnit minute = datePeriodUnitArray[n2];
            periodStrList.add(minute.getLabel());
            ++n2;
        }
        this.periodCombo.setItems(periodStrList.toArray(new String[DatePeriodUnit.values().length]));
        this.periodCombo.select(2);
        this.periodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Combo)e.widget).getSelectionIndex() == 0) {
                    this.setStartEndDate(30);
                } else if (((Combo)e.widget).getSelectionIndex() == 1) {
                    this.setStartEndDate(7);
                } else {
                    this.setStartEndDate(1);
                }
            }

            private void setStartEndDate(int i) {
                long yesterday = TimeUtil.getCurrentTime(CounterPastLongDateTotalView.this.serverId) - DatePeriodUnit.A_DAY.getTime();
                long startDate = TimeUtil.getCurrentTime(CounterPastLongDateTotalView.this.serverId) - DatePeriodUnit.A_DAY.getTime() * (long)i;
                CounterPastLongDateTotalView.this.sDateText.setText(DateUtil.format((long)startDate, (String)"yyyy-MM-dd"));
                CounterPastLongDateTotalView.this.eDateText.setText(DateUtil.format((long)yesterday, (String)"yyyy-MM-dd"));
                CounterPastLongDateTotalView.this.sDate = DateUtil.format((long)startDate, (String)"yyyyMMdd");
                CounterPastLongDateTotalView.this.eDate = DateUtil.format((long)yesterday, (String)"yyyyMMdd");
                CounterPastLongDateTotalView.this.stime = DateUtil.getTime((String)CounterPastLongDateTotalView.this.sDate, (String)"yyyyMMdd");
                CounterPastLongDateTotalView.this.etime = DateUtil.getTime((String)CounterPastLongDateTotalView.this.eDate, (String)"yyyyMMdd") + 86400000L;
            }
        });
        this.eDateText = new Label(this.headerComp, 0);
        this.eDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.periodCombo, -5, null, -1));
        this.eDateText.setText(DateUtil.format((long)(initialTime - 1L), (String)"yyyy-MM-dd"));
        Label windbarLabel = new Label(this.headerComp, 0);
        windbarLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, this.eDateText, -5, null, -1));
        windbarLabel.setText("~");
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 7, windbarLabel, -5, null, -1));
        this.sDateText.setText(DateUtil.format((long)initialTime, (String)"yyyy-MM-dd"));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.serverText.setText("\u24e2");
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String sDate:" + this.sDate + ", String eDate:" + this.eDate + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }

    @Override
    public void onPressedOk(String sDate, String eDate) {
        try {
            this.setInput(sDate, eDate, this.objType, this.counter, this.serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum DatePeriodUnit {
        A_MONTH("1 Month", -1702967296L),
        A_WEEK("1 Week", 604800000L),
        A_DAY("1 Day", 86400000L);

        private String label;
        private long time;

        private DatePeriodUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static DatePeriodUnit fromString(String text) {
            if (text != null) {
                DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
                int n = datePeriodUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DatePeriodUnit b = datePeriodUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

