/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenPastTimeAllAction;
import scouter.client.model.AgentColorManager;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.TimedSeries;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CounterPastTimeAllView
extends ScouterViewPart
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = CounterPastTimeAllView.class.getName();
    protected String objType;
    protected String counter;
    protected long startTime;
    protected long endTime;
    protected int serverId;
    Label serverText;
    Label sDateText;
    Label sTimeText;
    Label eTimeText;
    CalendarDialog calDialog;
    Composite headerComp;
    Trace nearestTrace;
    IWorkbenchWindow window;
    IToolBarManager man;
    boolean actionReg = false;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    private Map<Integer, Trace> traces = new HashMap<Integer, Trace>();

    public void setInput(long stime, long etime, String objType, String counter, int serverId) throws Exception {
        this.startTime = stime;
        this.endTime = etime;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        this.setViewTab(objType, counter, serverId, false);
        this.xyGraph.primaryXAxis.setRange(stime, etime);
        Server server = ServerManager.getInstance().getServer(serverId);
        String counterDisplay = "";
        if (server != null) {
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            this.desc = "(Past All) [" + DateUtil.format((long)stime, (String)"yyyy-MM-dd HH:mm:ss") + " ~ " + DateUtil.format((long)etime, (String)"HH:mm:ss") + "]" + counterDisplay;
        }
        this.serverText.setText("\u24e2" + (server == null ? "?" : server.getName()) + " |");
        this.sDateText.setText(DateUtil.format((long)stime, (String)"yyyy-MM-dd"));
        this.sTimeText.setText(DateUtil.format((long)stime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.eTimeText.setText(DateUtil.format((long)etime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        for (Trace tr : this.traces.values()) {
            this.xyGraph.removeTrace(tr);
        }
        this.traces.clear();
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objType, counter, stime, etime);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastTimeAllView.this.load(CounterPastTimeAllView.this.counter);
            }
        });
    }

    private void load(final String counter) {
        ArrayList values;
        block5: {
            values = new ArrayList();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("stime", this.startTime);
                    param.put("etime", this.endTime);
                    param.put("objType", this.objType);
                    param.put("counter", counter);
                    tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack mpack = (MapPack)in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                double max = 0.0;
                for (MapPack mpack : values) {
                    int objHash = mpack.getInt("objHash");
                    ListValue time = mpack.getList("time");
                    ListValue value = mpack.getList("value");
                    Trace trace = CounterPastTimeAllView.this.intern(objHash);
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)trace.getDataProvider();
                    provider.clearTrace();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        long x = time.getLong(i);
                        double y = value.getDouble(i);
                        provider.addSample(new Sample(x, y));
                        ++i;
                    }
                    max = Math.max(ChartUtil.getMax(provider.iterator()), max);
                }
                if (CounterUtil.isPercentValue(CounterPastTimeAllView.this.objType, counter)) {
                    CounterPastTimeAllView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterPastTimeAllView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastTimeAllView.this.redraw();
            }
        });
    }

    private void duplicateView() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String counterDisplay = "";
        if (server != null) {
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        }
        OpenPastTimeAllAction duplicateAction = new OpenPastTimeAllAction(this.window, counterDisplay, this.objType, this.counter, Images.getCounterImage(this.objType, this.counter, this.serverId), this.startTime, this.endTime, this.serverId);
        duplicateAction.run();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CounterPastTimeAllView.this.setInput((this).CounterPastTimeAllView.this.startTime, (this).CounterPastTimeAllView.this.endTime, (this).CounterPastTimeAllView.this.objType, (this).CounterPastTimeAllView.this.counter, (this).CounterPastTimeAllView.this.serverId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.man.add((IContributionItem)new Separator());
        this.man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        CounterPastTimeAllView.this.duplicateView();
                    }
                });
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)new Action("Export CSV", ImageUtil.getImageDescriptor(Images.csv)){

            public void run() {
                FileDialog dialog = new FileDialog(CounterPastTimeAllView.this.getViewSite().getShell(), 8192);
                dialog.setOverwrite(true);
                String filename = "[" + DateUtil.format((long)CounterPastTimeAllView.this.startTime, (String)"yyyyMMdd_HHmmss") + "-" + DateUtil.format((long)CounterPastTimeAllView.this.endTime, (String)"HHmmss") + "]" + CounterPastTimeAllView.this.objType + "_" + CounterPastTimeAllView.this.counter + ".csv";
                dialog.setFileName(filename);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV File(*.csv)", "All Files"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    new ExportDataTask(fileSelected).schedule();
                }
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastTimeAllView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowLegendAllowSize(r.width, r.height)) {
                        CounterPastTimeAllView.this.xyGraph.setShowLegend(true);
                    } else {
                        CounterPastTimeAllView.this.xyGraph.setShowLegend(false);
                    }
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastTimeAllView.this.setContentDescription(CounterPastTimeAllView.this.desc);
                    } else {
                        CounterPastTimeAllView.this.setContentDescription("");
                    }
                    r = CounterPastTimeAllView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterPastTimeAllView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CounterPastTimeAllView.this.nearestTrace != null) {
                    CounterPastTimeAllView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CounterPastTimeAllView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterPastTimeAllView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterPastTimeAllView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CounterPastTimeAllView.this.traces.values()) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CounterPastTimeAllView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CounterPastTimeAllView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CounterPastTimeAllView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CounterPastTimeAllView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterPastTimeAllView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CounterPastTimeAllView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CounterPastTimeAllView.this.setInput((this).CounterPastTimeAllView.this.startTime, (this).CounterPastTimeAllView.this.endTime, (this).CounterPastTimeAllView.this.objType, (this).CounterPastTimeAllView.this.counter, (this).CounterPastTimeAllView.this.serverId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        long initialTime = TimeUtil.getCurrentTime(this.serverId) - DatePeriodUnit.A_DAY.getTime();
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastTimeAllView.this.calDialog = new CalendarDialog(display, CounterPastTimeAllView.this);
                        CounterPastTimeAllView.this.calDialog.showWithTime(UIUtil.getMousePosition(), CounterPastTimeAllView.this.startTime);
                    }
                }
            }
        });
        this.eTimeText = new Label(this.headerComp, 0);
        this.eTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)manualBtn));
        this.eTimeText.setText(DateUtil.format((long)(initialTime + CalendarDialog.AfterMinuteUnit.FIVE_MIN.getTime()), (String)"hh:mm a", (Locale)Locale.ENGLISH));
        Label label = new Label(this.headerComp, 0);
        label.setLayoutData((Object)UIUtil.labelFormData((Control)this.eTimeText));
        label.setText("~");
        this.sTimeText = new Label(this.headerComp, 0);
        this.sTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)label));
        this.sTimeText.setText(DateUtil.format((long)initialTime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.labelFormData((Control)this.sTimeText));
        this.sDateText.setText(DateUtil.format((long)initialTime, (String)"yyyy-MM-dd"));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.serverText.setText("\u24e2");
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(long stime:" + this.startTime + ", long etime:" + this.endTime + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    private synchronized Trace intern(int objHash) {
        Trace trace = this.traces.get(objHash);
        if (trace != null) {
            return trace;
        }
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(true);
        traceDataProvider.setBufferSize((int)((this.endTime - this.startTime) / 2000L) + 1);
        traceDataProvider.setCurrentXDataArray(new double[0]);
        traceDataProvider.setCurrentYDataArray(new double[0]);
        String name = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)this.startTime), objHash, this.serverId));
        trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.NONE);
        trace.getXAxis().setTitle("");
        trace.getYAxis().setTitle("");
        trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        trace.getXAxis().setFormatPattern("HH:mm");
        trace.getYAxis().setFormatPattern("#,##0");
        trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, objHash));
        this.xyGraph.addTrace(trace);
        this.traces.put(objHash, trace);
        return trace;
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        try {
            this.setInput(startTime, endTime, this.objType, this.counter, this.serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    public static enum DatePeriodUnit {
        A_MONTH("1 Month", -1702967296L),
        A_WEEK("1 Week", 604800000L),
        A_DAY("1 Day", 86400000L);

        private String label;
        private long time;

        private DatePeriodUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static DatePeriodUnit fromString(String text) {
            if (text != null) {
                DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
                int n = datePeriodUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DatePeriodUnit b = datePeriodUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    class ExportDataTask
    extends Job {
        String filePath;

        public ExportDataTask(String filePath) {
            super("Export...");
            this.filePath = filePath;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                TimedSeries<String, Double> sereis = new TimedSeries<String, Double>();
                Range xRange = CounterPastTimeAllView.this.xyGraph.primaryXAxis.getRange();
                long lower = (long)xRange.getLower();
                long upper = (long)xRange.getUpper();
                List<Trace> traceList = CounterPastTimeAllView.this.xyGraph.getPlotArea().getTraceList();
                ArrayList<String> titleValues = new ArrayList<String>();
                titleValues.add("Time");
                for (Trace t : traceList) {
                    titleValues.add(t.getName());
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)t.getDataProvider();
                    int inx = 0;
                    while (inx < provider.getSize()) {
                        Sample sample = (Sample)provider.getSample(inx);
                        double x = sample.getXValue();
                        if (!(x < (double)lower) && !(x > (double)upper)) {
                            double y = sample.getYValue();
                            sereis.add(t.getName(), (long)x, y);
                        }
                        ++inx;
                    }
                }
                ArrayList<String[]> values = new ArrayList<String[]>();
                values.add(titleValues.toArray(new String[titleValues.size()]));
                while (lower < upper) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(DateUtil.format((long)lower, (String)"HH:mm:ss"));
                    int i = 1;
                    while (i < titleValues.size()) {
                        String objName = (String)titleValues.get(i);
                        Double d = (Double)sereis.getInTime(objName, lower, 3000L);
                        if (d != null) {
                            value.add(FormatUtil.print((Object)d, (String)"#,###.##"));
                        } else {
                            value.add("");
                        }
                        ++i;
                    }
                    values.add(value.toArray(new String[value.size()]));
                    lower += 2000L;
                }
                CSVWriter cw = new CSVWriter((Writer)new FileWriter(this.filePath));
                cw.writeAll(values);
                cw.flush();
                cw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

