/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenPastTimeTotalAction;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CounterPastTimeTotalView
extends ScouterViewPart
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = CounterPastTimeTotalView.class.getName();
    protected String objType;
    protected String counter;
    private String mode;
    protected int serverId;
    protected long startTime;
    protected long endTime;
    Label serverText;
    Label sDateText;
    Label sTimeText;
    Label eTimeText;
    CalendarDialog calDialog;
    Composite headerComp;
    IWorkbenchWindow window;
    IToolBarManager man;
    boolean actionReg = false;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void setInput(long stime, long etime, String objType, String counter, int serverId) throws Exception {
        this.startTime = stime;
        this.endTime = etime;
        this.objType = objType;
        this.counter = counter;
        this.mode = CounterUtil.getTotalMode(objType, counter);
        this.serverId = serverId;
        this.setViewTab(objType, counter, serverId);
        this.xyGraph.primaryXAxis.setRange(stime, etime);
        Server server = ServerManager.getInstance().getServer(serverId);
        this.serverText.setText("\u24e2" + (server == null ? "?" : server.getName()) + " |");
        this.sDateText.setText(DateUtil.format((long)stime, (String)"yyyy-MM-dd"));
        this.sTimeText.setText(DateUtil.format((long)stime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.eTimeText.setText(DateUtil.format((long)etime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objType, counter, stime, etime);
        this.traceDataProvider.setBufferSize((int)((etime - stime) / (long)TimeTypeEnum.getTime((byte)1) + 10L));
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                CounterPastTimeTotalView.this.load();
            }
        });
    }

    private void load() {
        ArrayList<Pack> values;
        block5: {
            values = new ArrayList<Pack>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("stime", this.startTime);
                    param.put("etime", this.endTime);
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            values.add(p);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, values, this.mode, (byte)1);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                double max = 0.0;
                CounterPastTimeTotalView.this.traceDataProvider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    CounterPastTimeTotalView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)time), CastUtil.cdouble(valueMap.get(time))));
                }
                max = Math.max(ChartUtil.getMax(CounterPastTimeTotalView.this.traceDataProvider.iterator()), max);
                if (CounterUtil.isPercentValue(CounterPastTimeTotalView.this.objType, CounterPastTimeTotalView.this.counter)) {
                    CounterPastTimeTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterPastTimeTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterPastTimeTotalView.this.redraw();
            }
        });
    }

    private void duplicateView() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String counterDisplay = "";
        if (server != null) {
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        }
        OpenPastTimeTotalAction duplicateAction = new OpenPastTimeTotalAction(this.window, counterDisplay, this.objType, this.counter, Images.getCounterImage(this.objType, this.counter, this.serverId), this.startTime, this.endTime, this.serverId);
        duplicateAction.run();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ExUtil.asyncRun(new Runnable(){

                    @Override
                    public void run() {
                        CounterPastTimeTotalView.this.load();
                    }
                });
            }
        });
        this.man.add((IContributionItem)new Separator());
        this.man.add((IAction)new Action("Duplicate", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        CounterPastTimeTotalView.this.duplicateView();
                    }
                });
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite chartComposite = new Composite(composite, 0);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        chartComposite.setLayout((Layout)UIUtil.formLayout(0, 0));
        chartComposite.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(chartComposite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterPastTimeTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterPastTimeTotalView.this.setDesc();
                    } else {
                        CounterPastTimeTotalView.this.setContentDescription("");
                    }
                    r = CounterPastTimeTotalView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterPastTimeTotalView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("HH:mm:ss");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CounterPastTimeTotalView.this.load();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
    }

    private void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        long initialTime = TimeUtil.getCurrentTime(this.serverId) - DatePeriodUnit.A_DAY.getTime();
        Button manualBtn = new Button(this.headerComp, 8);
        manualBtn.setImage(Images.CTXMENU_RDC);
        manualBtn.setText("Manual");
        manualBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        manualBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CounterPastTimeTotalView.this.calDialog = new CalendarDialog(display, CounterPastTimeTotalView.this);
                        CounterPastTimeTotalView.this.calDialog.showWithTime(UIUtil.getMousePosition(), CounterPastTimeTotalView.this.startTime);
                    }
                }
            }
        });
        this.eTimeText = new Label(this.headerComp, 0);
        this.eTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)manualBtn));
        this.eTimeText.setText(DateUtil.format((long)(initialTime + CalendarDialog.AfterMinuteUnit.FIVE_MIN.getTime()), (String)"hh:mm a", (Locale)Locale.ENGLISH));
        Label label = new Label(this.headerComp, 0);
        label.setLayoutData((Object)UIUtil.labelFormData((Control)this.eTimeText));
        label.setText("~");
        this.sTimeText = new Label(this.headerComp, 0);
        this.sTimeText.setLayoutData((Object)UIUtil.labelFormData((Control)label));
        this.sTimeText.setText(DateUtil.format((long)initialTime, (String)"hh:mm a", (Locale)Locale.ENGLISH));
        this.sDateText = new Label(this.headerComp, 0);
        this.sDateText.setLayoutData((Object)UIUtil.labelFormData((Control)this.sTimeText));
        this.sDateText.setText(DateUtil.format((long)initialTime, (String)"yyyy-MM-dd"));
        this.serverText = new Label(this.headerComp, 131072);
        this.serverText.setLayoutData((Object)UIUtil.formData(0, 0, 0, 7, this.sDateText, -5, null, -1));
        this.serverText.setText("\u24e2");
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(long stime:" + this.startTime + ", long etime:" + this.endTime + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        try {
            this.setInput(startTime, endTime, this.objType, this.counter, this.serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }

    public static enum DatePeriodUnit {
        A_MONTH("1 Month", -1702967296L),
        A_WEEK("1 Week", 604800000L),
        A_DAY("1 Day", 86400000L);

        private String label;
        private long time;

        private DatePeriodUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static DatePeriodUnit fromString(String text) {
            if (text != null) {
                DatePeriodUnit[] datePeriodUnitArray = DatePeriodUnit.values();
                int n = datePeriodUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DatePeriodUnit b = datePeriodUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

