/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.HashMap;
import java.util.Iterator;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.counter.actions.OpenPTPairAllAction;
import scouter.client.counter.views.CounterAllPairPainter;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class CounterRTAllPairChart
extends CounterAllPairPainter
implements RefreshThread.Refreshable {
    public static final String ID = CounterRTAllPairChart.class.getName();
    protected RefreshThread thread = null;
    private int serverId;
    private String objType;
    private String counter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
            Server server = ServerManager.getInstance().getServer(this.serverId);
            CounterEngine ce = server.getCounterEngine();
            String counterName = ce.getCounterDisplayName(this.objType, this.counter);
            this.desc = "\u24e2" + server.getName() + " | (Current All) " + counterName + "(" + ce.getCounterUnit(this.objType, this.counter) + ")";
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new OpenPTPairAllAction(this.getViewSite().getWorkbenchWindow(), "Load", this.serverId, this.objType, this.counter));
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    @Override
    public void refresh() {
        HashMap<Integer, Value> values;
        block7: {
            values = new HashMap<Integer, Value>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    MapPack out = (MapPack)tcp.getSingle("COUNTER_REAL_TIME_ALL", (Pack)param);
                    this.isActive = false;
                    if (out != null) {
                        ListValue objHash = out.getList("objHash");
                        ListValue v = out.getList("value");
                        int i = 0;
                        while (i < objHash.size()) {
                            values.put(CastUtil.cint((Object)objHash.get(i)), v.get(i));
                            this.isActive = true;
                            ++i;
                        }
                    }
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRTAllPairChart.this.isActive) {
                    CounterRTAllPairChart.this.setActive();
                } else {
                    CounterRTAllPairChart.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime(CounterRTAllPairChart.this.serverId);
                CounterRTAllPairChart.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                Iterator itr = values.keySet().iterator();
                while (itr.hasNext()) {
                    int objHash = (Integer)itr.next();
                    Value value = (Value)values.get(objHash);
                    if (value == null || value.getValueType() != 70) continue;
                    ListValue lv = (ListValue)value;
                    CounterAllPairPainter.TracePair tp = CounterRTAllPairChart.this.getTracePair(CounterRTAllPairChart.this.objType, objHash, 155);
                    CircularBufferDataProvider provider1 = (CircularBufferDataProvider)tp.totalTrace.getDataProvider();
                    CircularBufferDataProvider provider2 = (CircularBufferDataProvider)tp.activeTrace.getDataProvider();
                    provider1.addSample(new Sample(now, CastUtil.cdouble((Object)lv.get(0))));
                    provider2.addSample(new Sample(now, CastUtil.cdouble((Object)lv.get(1))));
                }
                if (CounterUtil.isPercentValue(CounterRTAllPairChart.this.objType, CounterRTAllPairChart.this.counter)) {
                    CounterRTAllPairChart.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = CounterRTAllPairChart.this.getMaxValue();
                    CounterRTAllPairChart.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterRTAllPairChart.this.redraw();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

