/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.HashMap;
import java.util.Iterator;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.counter.actions.OpenPTPairAllAction2;
import scouter.client.counter.views.CounterAllPairPainter;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class CounterRTAllPairChart2
extends CounterAllPairPainter
implements RefreshThread.Refreshable {
    public static final String ID = CounterRTAllPairChart2.class.getName();
    protected RefreshThread thread = null;
    private int serverId;
    private String objType;
    private String counter1;
    private String counter2;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter1 = ids[2];
        this.counter2 = ids[3];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.setViewTab(this.objType, this.counter1, this.serverId);
            Server server = ServerManager.getInstance().getServer(this.serverId);
            CounterEngine ce = server.getCounterEngine();
            String counterName = ce.getCounterDisplayName(this.objType, this.counter1);
            this.desc = "\u24e2" + server.getName() + " | (Current All) " + counterName + "(" + ce.getCounterUnit(this.objType, this.counter1) + ")";
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new OpenPTPairAllAction2(this.getViewSite().getWorkbenchWindow(), "Load", this.serverId, this.objType, this.counter1, this.counter2));
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter1 + ", serverId:" + this.serverId);
        this.thread.start();
    }

    @Override
    public void refresh() {
        HashMap<Integer, MapValue> values;
        block8: {
            values = new HashMap<Integer, MapValue>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    ListValue counterList = param.newList("counter");
                    counterList.add(this.counter1);
                    counterList.add(this.counter2);
                    MapPack out = (MapPack)tcp.getSingle("COUNTER_REAL_TIME_ALL_MULTI", (Pack)param);
                    this.isActive = false;
                    if (out != null) {
                        ListValue objHashLv = out.getList("objHash");
                        ListValue counterLv = out.getList("counter");
                        ListValue valueLv = out.getList("value");
                        int i = 0;
                        while (i < objHashLv.size()) {
                            int objHash = CastUtil.cint((Object)objHashLv.get(i));
                            MapValue mv = (MapValue)values.get(objHash);
                            if (mv == null) {
                                mv = new MapValue();
                                values.put(objHash, mv);
                            }
                            mv.put(counterLv.getString(i), valueLv.get(i));
                            this.isActive = true;
                            ++i;
                        }
                    }
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRTAllPairChart2.this.isActive) {
                    CounterRTAllPairChart2.this.setActive();
                } else {
                    CounterRTAllPairChart2.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime(CounterRTAllPairChart2.this.serverId);
                CounterRTAllPairChart2.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                Iterator itr = values.keySet().iterator();
                while (itr.hasNext()) {
                    int objHash = (Integer)itr.next();
                    Value value = (Value)values.get(objHash);
                    if (value == null || value.getValueType() != 80) continue;
                    MapValue mv = (MapValue)value;
                    CounterAllPairPainter.TracePair tp = CounterRTAllPairChart2.this.getTracePair(CounterRTAllPairChart2.this.objType, objHash, 155);
                    CircularBufferDataProvider provider1 = (CircularBufferDataProvider)tp.totalTrace.getDataProvider();
                    CircularBufferDataProvider provider2 = (CircularBufferDataProvider)tp.activeTrace.getDataProvider();
                    provider1.addSample(new Sample(now, CastUtil.cdouble((Object)mv.get(CounterRTAllPairChart2.this.counter1))));
                    provider2.addSample(new Sample(now, CastUtil.cdouble((Object)mv.get(CounterRTAllPairChart2.this.counter2))));
                }
                if (CounterUtil.isPercentValue(CounterRTAllPairChart2.this.objType, CounterRTAllPairChart2.this.counter1)) {
                    CounterRTAllPairChart2.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = CounterRTAllPairChart2.this.getMaxValue();
                    CounterRTAllPairChart2.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterRTAllPairChart2.this.redraw();
            }
        });
    }
}

