/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentColorManager;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterRealCountView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterRealCountView.class.getName();
    private IMemento memento;
    protected RefreshThread thread;
    protected String objType;
    protected String counter;
    protected int objHash;
    protected int serverId;
    private boolean isActive = false;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;
    private int leftMargin = 0;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void setInput(String objType, String counter, int objHash, int serverId) throws Exception {
        this.objHash = objHash;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        String objName = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(serverId)), objHash, serverId));
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        this.desc = "\u24e2" + svrName + " | (Realtime) [" + objName + "] " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.trace.setName(objName);
        this.trace.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
        this.setViewTab(objType, counter, serverId);
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 5000);
            this.thread.start();
        }
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + objType + ", counter:" + counter + ", objHash:" + objHash + ", serverId:" + serverId);
    }

    @Override
    public void refresh() {
        MapPack out;
        block7: {
            this.isActive = false;
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            out = null;
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    param.put("counter", this.counter);
                    param.put("timetype", 3L);
                    out = (MapPack)tcp.getSingle("COUNTER_TODAY", (Pack)param);
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final long[] values = new long[24];
        if (out != null) {
            this.isActive = true;
            ListValue timeLv = out.getList("time");
            ListValue valueLv = out.getList("value");
            int i = 0;
            while (i < timeLv.size()) {
                int index;
                long time = timeLv.getLong(i);
                int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                values[n] = values[n] + valueLv.getLong(i);
                ++i;
            }
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (!CounterRealCountView.this.isActive) {
                    CounterRealCountView.this.setInactive();
                    return;
                }
                CounterRealCountView.this.setActive();
                double max = 0.0;
                CounterRealCountView.this.traceDataProvider.clearTrace();
                int i = 0;
                while (i < values.length) {
                    CounterRealCountView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                    ++i;
                }
                max = Math.max(ChartUtil.getMax(CounterRealCountView.this.traceDataProvider.iterator()), max);
                if (CounterUtil.isPercentValue(CounterRealCountView.this.objType, CounterRealCountView.this.counter)) {
                    CounterRealCountView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterRealCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterRealCountView.this.canvas.redraw();
                CounterRealCountView.this.xyGraph.repaint();
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, this.leftMargin, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealCountView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealCountView.this.setContentDescription(CounterRealCountView.this.desc);
                    } else {
                        CounterRealCountView.this.setContentDescription("");
                    }
                    r = CounterRealCountView.this.canvas.getClientArea();
                    this.lock = false;
                }
                if (CounterRealCountView.this.xyGraph == null) {
                    return;
                }
                CounterRealCountView.this.xyGraph.setSize(r.width, r.height);
                CounterRealCountView.this.trace.setLineWidth(r.width / 30);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(false);
        this.xyGraph.primaryXAxis.setShowMajorGrid(false);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(24);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.xyGraph.primaryXAxis.setRange(0.0, 24.0);
        this.trace = new Trace("temp", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(15);
        this.trace.setTraceType(Trace.TraceType.BAR);
        this.trace.setAreaAlpha(200);
        this.xyGraph.addTrace(this.trace);
        this.restoreState();
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int objHash:" + this.objHash + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento = memento.createChild(ID);
        memento.putString("objType", this.objType);
        memento.putString("counter", this.counter);
        memento.putInteger("objHash", this.objHash);
        memento.putInteger("serverId", this.serverId);
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        IMemento m = this.memento.getChild(ID);
        String objType = m.getString("objType");
        String counter = m.getString("counter");
        int objHash = CastUtil.cint((Object)m.getInteger("objHash"));
        int serverId = CastUtil.cint((Object)m.getInteger("serverId"));
        try {
            this.setInput(objType, counter, objHash, serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

