/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.model.AgentColorManager;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.CounterKey;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CounterRealDateView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterRealDateView.class.getName();
    protected String objName;
    protected int objHash;
    protected String counter;
    protected int serverId;
    protected RefreshThread thread;
    private IMemento memento;
    IWorkbenchWindow window;
    protected String objType;
    boolean isActive = false;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void setInput(int objHash, String objName, String objType, String counter, int serverId) throws Exception {
        this.objHash = objHash;
        this.objName = objName;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        this.desc = "\u24e2" + svrName + " | (Today) [" + objName + "] " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.setViewTab(objType, counter, serverId);
        if (this.trace != null) {
            this.trace.setName(objName);
            this.trace.setTraceColor(AgentColorManager.getInstance().assignColor(objType, objHash));
            ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, AgentColorManager.getInstance().assignColor(objType, objHash));
        }
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objHash, objType, counter);
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 10000);
            this.thread.start();
        }
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objHash:" + objHash + ", objName:" + objName + ", objType:" + objType + ", counter:" + counter + ", serverId:" + serverId);
    }

    @Override
    public void refresh() {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        MapPack out = null;
        this.isActive = false;
        try {
            MapPack param = CounterKey.toMapPacket((CounterKey)new CounterKey(this.objHash, this.counter, 3));
            out = (MapPack)tcp.getSingle("COUNTER_TODAY", (Pack)param);
            this.isActive = true;
            if (out == null) {
                return;
            }
        }
        catch (Throwable t) {
            ConsoleProxy.errorSafe(t.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        final ListValue time = out.getList("time");
        final ListValue value = out.getList("value");
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealDateView.this.isActive) {
                    CounterRealDateView.this.setActive();
                } else {
                    CounterRealDateView.this.setInactive();
                }
                CounterRealDateView.this.traceDataProvider.clearTrace();
                int i = 0;
                while (time != null && i < time.size()) {
                    long x = CastUtil.clong((Object)time.get(i));
                    double y = CastUtil.cdouble((Object)value.get(i));
                    CounterRealDateView.this.traceDataProvider.addSample(new Sample(x, y));
                    ++i;
                }
                String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(CounterRealDateView.this.serverId));
                long stime = DateUtil.getTime((String)date, (String)"yyyyMMdd");
                long etime = stime + 86400000L;
                CounterRealDateView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                if (CounterUtil.isPercentValue(CounterRealDateView.this.objType, CounterRealDateView.this.counter)) {
                    CounterRealDateView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterRealDateView.this.xyGraph.primaryYAxis.setRange(0.0, ChartUtil.getMax(CounterRealDateView.this.traceDataProvider.iterator()));
                }
                CounterRealDateView.this.canvas.redraw();
                CounterRealDateView.this.xyGraph.repaint();
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealDateView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealDateView.this.setContentDescription(CounterRealDateView.this.desc);
                    } else {
                        CounterRealDateView.this.setContentDescription("");
                    }
                    r = CounterRealDateView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterRealDateView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(288);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("HH:mm");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().getColor(14));
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, ColorUtil.getInstance().getColor(14));
        this.restoreState();
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(int objHash:" + this.objHash + ", String objName:" + this.objName + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento = memento.createChild(ID);
        memento.putInteger("objHash", this.objHash);
        memento.putString("objName", this.objName);
        memento.putString("objType", this.objType);
        memento.putString("counter", this.counter);
        memento.putInteger("serverId", this.serverId);
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        IMemento m = this.memento.getChild(ID);
        if (m == null) {
            return;
        }
        int objHash = CastUtil.cint((Object)m.getInteger("objHash"));
        String objName = m.getString("objName");
        String objType = m.getString("objType");
        String counter = m.getString("counter");
        int serverId = CastUtil.cint((Object)m.getInteger("serverId"));
        try {
            this.setInput(objHash, objName, objType, counter, serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

