/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;
import scouter.util.StringUtil;

public class CounterRealTimeAllView
extends ScouterViewPart
implements RefreshThread.Refreshable,
ObjectSelectManager.IObjectCheckListener {
    public static final String ID = CounterRealTimeAllView.class.getName();
    protected RefreshThread thread = null;
    private int serverId;
    private String objType;
    private String counter;
    private boolean manualRefresh = false;
    boolean isActive = false;
    protected XYGraph xyGraph;
    protected Map<Integer, CircularBufferDataProvider> datas = new HashMap<Integer, CircularBufferDataProvider>();
    protected FigureCanvas canvas;
    Trace nearestTrace;
    ArrayList<Trace> traces = new ArrayList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeAllView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowLegendAllowSize(r.width, r.height)) {
                        CounterRealTimeAllView.this.xyGraph.setShowLegend(true);
                    } else {
                        CounterRealTimeAllView.this.xyGraph.setShowLegend(false);
                    }
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealTimeAllView.this.setContentDescription(CounterRealTimeAllView.this.desc);
                    } else {
                        CounterRealTimeAllView.this.setContentDescription("");
                    }
                    r = CounterRealTimeAllView.this.canvas.getClientArea();
                    CounterRealTimeAllView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CounterRealTimeAllView.this.nearestTrace != null) {
                    CounterRealTimeAllView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CounterRealTimeAllView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterRealTimeAllView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterRealTimeAllView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CounterRealTimeAllView.this.traces) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CounterRealTimeAllView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CounterRealTimeAllView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CounterRealTimeAllView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CounterRealTimeAllView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterRealTimeAllView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CounterRealTimeAllView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x100000E: {
                        CounterRealTimeAllView.this.manualRefresh = true;
                        int i = 0;
                        while (i < CounterRealTimeAllView.this.traces.size()) {
                            CounterRealTimeAllView.this.xyGraph.removeTrace(CounterRealTimeAllView.this.traces.get(i));
                            ++i;
                        }
                        CounterRealTimeAllView.this.thread.interrupt();
                    }
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterRealTimeAllView.this.manualRefresh = true;
                int i = 0;
                while (i < CounterRealTimeAllView.this.traces.size()) {
                    CounterRealTimeAllView.this.xyGraph.removeTrace(CounterRealTimeAllView.this.traces.get(i));
                    ++i;
                }
                CounterRealTimeAllView.this.thread.interrupt();
            }
        });
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
            counterUnit = server.getCounterEngine().getCounterUnit(this.objType, this.counter);
        }
        this.desc = "\u24e2" + svrName + " | (Current All) " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, this.serverId, this.objType, this.counter, 0L, 0L);
        ObjectSelectManager.getInstance().addObjectCheckStateListener(this);
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    @Override
    public void refresh() {
        HashMap<Integer, Value> values;
        block8: {
            if (this.manualRefresh) {
                this.manualRefresh = false;
                this.traces.clear();
                this.datas.clear();
                this.getPrevAllPerf();
            }
            values = new HashMap<Integer, Value>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    MapPack out = (MapPack)tcp.getSingle("COUNTER_REAL_TIME_ALL", (Pack)param);
                    this.isActive = false;
                    if (out != null) {
                        ListValue objHash = out.getList("objHash");
                        ListValue v = out.getList("value");
                        int i = 0;
                        while (i < objHash.size()) {
                            values.put(CastUtil.cint((Object)objHash.get(i)), v.get(i));
                            this.isActive = true;
                            ++i;
                        }
                    }
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealTimeAllView.this.isActive) {
                    CounterRealTimeAllView.this.setActive();
                } else {
                    CounterRealTimeAllView.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime(CounterRealTimeAllView.this.serverId);
                CounterRealTimeAllView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                Iterator itr = values.keySet().iterator();
                while (itr.hasNext()) {
                    int objHash = (Integer)itr.next();
                    Value value = (Value)values.get(objHash);
                    if (value == null || value.getValueType() == 0) continue;
                    CircularBufferDataProvider data = CounterRealTimeAllView.this.getDataProvider(objHash);
                    data.addSample(new Sample(now, CastUtil.cdouble((Object)value)));
                }
                if (CounterUtil.isPercentValue(CounterRealTimeAllView.this.objType, CounterRealTimeAllView.this.counter)) {
                    CounterRealTimeAllView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = CounterRealTimeAllView.this.getMaxValue();
                    CounterRealTimeAllView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterRealTimeAllView.this.redraw();
            }
        });
        this.checkSettingChange();
    }

    private void checkSettingChange() {
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int width = PManager.getInstance().getInt("lineWidth");
                ArrayList<Trace> arrayList = CounterRealTimeAllView.this.traces;
                synchronized (arrayList) {
                    for (Trace t : CounterRealTimeAllView.this.traces) {
                        if (CounterRealTimeAllView.this.nearestTrace == null && t.getLineWidth() != width) {
                            t.setLineWidth(width);
                        }
                        int objHash = HashUtil.hash((String)t.getName());
                        AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
                        if (agent == null || !agent.isAlive() || agent.getColor() == null) {
                            return;
                        }
                        if (t.getTraceColor() == agent.getColor()) continue;
                        t.setTraceColor(agent.getColor());
                    }
                }
            }
        });
    }

    private void getPrevAllPerf() {
        ArrayList values;
        block5: {
            values = new ArrayList();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    long etime = TimeUtil.getCurrentTime(this.serverId);
                    long stime = etime - 300000L;
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            MapPack mpack = (MapPack)in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                for (MapPack mpack : values) {
                    int objHash = mpack.getInt("objHash");
                    ListValue time = mpack.getList("time");
                    ListValue value = mpack.getList("value");
                    if (time == null || time.size() < 1) continue;
                    CircularBufferDataProvider provider = CounterRealTimeAllView.this.getDataProvider(objHash);
                    provider.clearTrace();
                    int i = 0;
                    while (time != null && i < time.size()) {
                        long x = time.getLong(i);
                        double y = value.getDouble(i);
                        provider.addSample(new Sample(x, y));
                        ++i;
                    }
                }
            }
        });
    }

    private CircularBufferDataProvider getDataProvider(int objHash) {
        CircularBufferDataProvider data = this.datas.get(objHash);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(objHash, data);
            data.setBufferSize(155);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            String name = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), objHash, this.serverId));
            Trace trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, objHash));
            this.xyGraph.addTrace(trace);
            this.traces.add(trace);
        }
        return data;
    }

    private double getMaxValue() {
        Iterator<Integer> objHashs = this.datas.keySet().iterator();
        double max = 0.0;
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        while (objHashs.hasNext()) {
            int objHash = objHashs.next();
            CircularBufferDataProvider data = this.datas.get(objHash);
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getMaxValue(max);
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
        ObjectSelectManager.getInstance().removeObjectCheckStateListener(this);
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    @Override
    public void notifyChangeState() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                for (Trace t : CounterRealTimeAllView.this.traces) {
                    String objName = t.getName();
                    if (ObjectSelectManager.getInstance().isUnselectedObject(HashUtil.hash((String)objName))) {
                        t.setVisible(false);
                        continue;
                    }
                    t.setVisible(true);
                }
                ExUtil.exec((Composite)CounterRealTimeAllView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        CounterRealTimeAllView.this.redraw();
                    }
                });
            }
        });
    }
}

