/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.CounterColorManager;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CounterRealTimeMultiView
extends ViewPart
implements RefreshThread.Refreshable {
    public static String ID = CounterRealTimeMultiView.class.getName();
    int serverId;
    int objHash;
    String objType;
    String title;
    List<String> counters = new ArrayList<String>();
    CounterEngine counterEngine;
    RefreshThread thread;
    FigureCanvas canvas;
    XYGraph xyGraph;
    HashMap<String, Trace> traceMap = new HashMap();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objHash = CastUtil.cint((Object)ids[1]);
        this.objType = ids[2];
        this.title = ids[3];
        int i = 4;
        while (i < ids.length) {
            this.counters.add(ids[i]);
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        this.counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        String objName = TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), this.objHash, this.serverId);
        this.setPartName(String.valueOf(this.title) + "[" + objName + "]");
        parent.setLayout((Layout)new GridLayout());
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeMultiView.this.canvas.getClientArea();
                CounterRealTimeMultiView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowTitle(false);
        this.xyGraph.setShowLegend(true);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        for (String counter : this.counters) {
            String name = this.counterEngine.getCounterDisplayName(this.objType, counter);
            CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
            provider.setBufferSize(155);
            Trace trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(CounterColorManager.getInstance().assignColor(counter));
            this.traceMap.put(counter, trace);
            this.xyGraph.addTrace(trace);
        }
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    public void setFocus() {
    }

    @Override
    public void refresh() {
        ListValue counterLv;
        Pack p;
        block8: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            p = null;
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    counterLv = param.newList("counter");
                    for (String counter : this.counters) {
                        counterLv.add(counter);
                    }
                    p = tcp.getSingle("COUNTER_REAL_TIME_MULTI", (Pack)param);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (p == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CounterRealTimeMultiView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime(CounterRealTimeMultiView.this.serverId);
                    CounterRealTimeMultiView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                }
            });
        } else {
            MapPack m = (MapPack)p;
            counterLv = m.getList("counter");
            final ListValue valueLv = m.getList("value");
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    long now = TimeUtil.getCurrentTime(CounterRealTimeMultiView.this.serverId);
                    CounterRealTimeMultiView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                    int size = counterLv.size();
                    if (size > 0) {
                        CounterRealTimeMultiView.this.setTitleImage(Images.active);
                    } else {
                        CounterRealTimeMultiView.this.setTitleImage(Images.inactive);
                    }
                    double max = 0.0;
                    int i = 0;
                    while (i < counterLv.size()) {
                        String counter = counterLv.getString(i);
                        double value = valueLv.getDouble(i);
                        Trace t = CounterRealTimeMultiView.this.traceMap.get(counter);
                        CircularBufferDataProvider provider = (CircularBufferDataProvider)t.getDataProvider();
                        provider.addSample(new Sample(now, value));
                        double max2 = ChartUtil.getMax(provider.iterator());
                        if (max2 > max) {
                            max = max2;
                        }
                        ++i;
                    }
                    CounterRealTimeMultiView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

