/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DoubleValue;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class CounterRealTimeTotalView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterRealTimeTotalView.class.getName();
    protected String objType;
    protected String counter;
    protected int serverId;
    private String mode;
    protected RefreshThread thread = null;
    boolean manualRefresh = false;
    boolean isActive = false;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;
    GridData data;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealTimeTotalView.this.setContentDescription(CounterRealTimeTotalView.this.desc);
                    } else {
                        CounterRealTimeTotalView.this.setContentDescription("");
                    }
                    r = CounterRealTimeTotalView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterRealTimeTotalView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setFormatPattern("HH:mm:ss");
        this.xyGraph.primaryYAxis.setFormatPattern("#,##0");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(155);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterRealTimeTotalView.this.manualRefresh = true;
                    CounterRealTimeTotalView.this.thread.interrupt();
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterRealTimeTotalView.this.manualRefresh = true;
                CounterRealTimeTotalView.this.thread.interrupt();
            }
        });
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
            counterUnit = server.getCounterEngine().getCounterUnit(this.objType, this.counter);
        }
        this.desc = "\u24e2" + svrName + " | (Current Total) " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, this.serverId, this.objType, this.counter, 0L, 0L);
        this.thread = new RefreshThread(this, 2000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    @Override
    public void refresh() {
        List<Pack> result;
        DoubleValue value;
        block7: {
            if (this.manualRefresh) {
                this.manualRefresh = false;
                this.getPrevTotalPerf();
            }
            MapPack map = new MapPack();
            map.put("objType", this.objType);
            map.put("counter", this.counter);
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            value = new DoubleValue();
            this.isActive = false;
            result = null;
            try {
                try {
                    result = tcp.process("COUNTER_REAL_TIME_ALL", (Pack)map);
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (result.size() > 0) {
            value.value = ScouterUtil.getRealTotalValue(this.counter, result, this.mode);
            this.isActive = true;
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealTimeTotalView.this.isActive) {
                    CounterRealTimeTotalView.this.setActive();
                } else {
                    CounterRealTimeTotalView.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime(CounterRealTimeTotalView.this.serverId);
                CounterRealTimeTotalView.this.traceDataProvider.addSample(new Sample(now, value.value));
                CounterRealTimeTotalView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                if (CounterUtil.isPercentValue(CounterRealTimeTotalView.this.objType, CounterRealTimeTotalView.this.counter)) {
                    CounterRealTimeTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(CounterRealTimeTotalView.this.traceDataProvider.iterator());
                    CounterRealTimeTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterRealTimeTotalView.this.canvas.redraw();
                CounterRealTimeTotalView.this.xyGraph.repaint();
            }
        });
    }

    private void getPrevTotalPerf() {
        ArrayList<Pack> values;
        block5: {
            values = new ArrayList<Pack>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    long etime = TimeUtil.getCurrentTime(this.serverId);
                    long stime = etime - 300000L;
                    MapPack param = new MapPack();
                    param.put("stime", stime);
                    param.put("etime", etime);
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_PAST_TIME_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack mpack = in.readPack();
                            values.add(mpack);
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, values, this.mode, (byte)1);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterRealTimeTotalView.this.traceDataProvider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    double value = CastUtil.cdouble(valueMap.get(time));
                    CounterRealTimeTotalView.this.traceDataProvider.addSample(new Sample(time, value));
                }
            }
        });
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public void addValue(long now, double value) {
        this.traceDataProvider.addSample(new Sample(now, value));
    }
}

