/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.AgentColorManager;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class CounterRealTimeView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterRealTimeView.class.getName();
    protected String objName;
    protected int objHash;
    protected String objType;
    protected String counter;
    protected int serverId;
    protected RefreshThread thread;
    private IMemento memento;
    IWorkbenchWindow window;
    IToolBarManager man;
    private boolean init = false;
    boolean isActive = false;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    protected Map<String, CircularBufferDataProvider> datas = new HashMap<String, CircularBufferDataProvider>();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void setInput(int objHash, String objName, String objType, String counter, int serverId) throws Exception {
        if (this.thread != null && this.thread.isAlive()) {
            return;
        }
        this.objHash = objHash;
        this.objName = objName;
        this.objType = objType;
        this.counter = counter;
        this.serverId = serverId;
        Server server = ServerManager.getInstance().getServer(serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(objType, counter);
            counterUnit = server.getCounterEngine().getCounterUnit(objType, counter);
        }
        if (server == null) {
            return;
        }
        this.desc = "\u24e2" + svrName + " | (Realtime) [" + objName + "] " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        this.setViewTab(objType, counter, serverId);
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, serverId, objHash, objType, counter);
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 2000);
            this.thread.start();
        }
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objHash:" + objHash + ", objName:" + objName + ", objType:" + objType + ", counter:" + counter + ", serverId:" + serverId);
    }

    public void getRealtimePrevPerf(int objHash, String objType, String counter) {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            param.put("objType", objType);
            param.put("counter", counter);
            long etime = TimeUtil.getCurrentTime(this.serverId);
            long stime = etime - 300000L;
            param.put("stime", stime);
            param.put("etime", etime);
            MapPack out = (MapPack)tcp.getSingle("COUNTER_PAST_TIME", (Pack)param);
            if (out == null) {
                return;
            }
            try {
                ListValue time = out.getList("time");
                ListValue value = out.getList("value");
                HashMap<Long, Value> map = new HashMap<Long, Value>();
                int i = 0;
                while (time != null && i < time.size()) {
                    map.put(CastUtil.clong((Object)time.get(i)), value.get(i));
                    ++i;
                }
                final TreeMap treeMap = new TreeMap(map);
                ExUtil.exec((Composite)this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        Iterator xs = treeMap.keySet().iterator();
                        CounterRealTimeView.this.clearAllTrace();
                        while (xs.hasNext()) {
                            long tm = (Long)xs.next();
                            Value v = (Value)treeMap.get(tm);
                            if (v instanceof ListValue) {
                                ListValue list = (ListValue)v;
                                int j = 0;
                                int size = list.size();
                                while (j < size) {
                                    CounterRealTimeView.this.getDataProvider("data-" + j).addSample(new Sample(tm, list.getDouble(j)));
                                    ++j;
                                }
                                continue;
                            }
                            if (v == null || v.getValueType() == 0) continue;
                            CounterRealTimeView.this.getDataProvider("data").addSample(new Sample(tm, CastUtil.cdouble((Object)v)));
                        }
                    }
                });
            }
            catch (Throwable t) {
                ConsoleProxy.errorSafe(t.toString());
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }

    @Override
    public void refresh() {
        Stack value;
        block6: {
            if (!this.init) {
                this.init = true;
                this.clearAllTrace();
                this.getRealtimePrevPerf(this.objHash, this.objType, this.counter);
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            value = new Stack();
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    param.put("counter", this.counter);
                    param.put("timetype", 1L);
                    this.isActive = false;
                    tcp.process("COUNTER_REAL_TIME", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Value v = in.readValue();
                            if (v != null && v.getValueType() != 0) {
                                value.push(v);
                                CounterRealTimeView.this.isActive = true;
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterRealTimeView.this.isActive) {
                    CounterRealTimeView.this.setActive();
                } else {
                    CounterRealTimeView.this.setInactive();
                }
                long now = TimeUtil.getCurrentTime(CounterRealTimeView.this.serverId);
                CounterRealTimeView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                double maxv = 0.0;
                if (value.size() > 0) {
                    Value v = (Value)value.pop();
                    if (v instanceof ListValue) {
                        ListValue list = (ListValue)v;
                        int j = 0;
                        int max = list.size();
                        while (j < max) {
                            CounterRealTimeView.this.getDataProvider("data-" + j).addSample(new Sample(now, list.getDouble(j)));
                            maxv = Math.max(ChartUtil.getMax(CounterRealTimeView.this.getDataProvider("data-" + j).iterator()), maxv);
                            ++j;
                        }
                    } else if (v.getValueType() != 0) {
                        CounterRealTimeView.this.getDataProvider("data").addSample(new Sample(now, CastUtil.cdouble((Object)v)));
                        maxv = ChartUtil.getMax(CounterRealTimeView.this.getDataProvider("data").iterator());
                    }
                }
                if (CounterUtil.isPercentValue(CounterRealTimeView.this.objType, CounterRealTimeView.this.counter)) {
                    CounterRealTimeView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    CounterRealTimeView.this.xyGraph.primaryYAxis.setRange(0.0, maxv);
                }
                CounterRealTimeView.this.canvas.redraw();
                CounterRealTimeView.this.xyGraph.repaint();
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterRealTimeView.this.init = false;
                CounterRealTimeView.this.refresh();
            }
        });
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterRealTimeView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterRealTimeView.this.setContentDescription(CounterRealTimeView.this.desc);
                    } else {
                        CounterRealTimeView.this.setContentDescription("");
                    }
                    r = CounterRealTimeView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterRealTimeView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        this.restoreState();
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterRealTimeView.this.init = false;
                    CounterRealTimeView.this.refresh();
                }
            }
        });
    }

    private void clearAllTrace() {
        for (String providerName : this.datas.keySet()) {
            CircularBufferDataProvider provider = this.datas.get(providerName);
            provider.clearTrace();
        }
    }

    private CircularBufferDataProvider getDataProvider(String linename) {
        CircularBufferDataProvider data = this.datas.get(linename);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(linename, data);
            data.setBufferSize(155);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            Trace trace = new Trace(linename, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, this.objHash));
            this.xyGraph.addTrace(trace);
        }
        return data;
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(int objHash:" + this.objHash + ", String objName:" + this.objName + ", String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento = memento.createChild(ID);
        memento.putInteger("objHash", this.objHash);
        memento.putString("objName", this.objName);
        memento.putString("objType", this.objType);
        memento.putString("counter", this.counter);
        memento.putInteger("serverId", this.serverId);
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        IMemento m = this.memento.getChild(ID);
        int objHash = CastUtil.cint((Object)m.getInteger("objHash"));
        String objName = m.getString("objName");
        String objType = m.getString("objType");
        String counter = m.getString("counter");
        int serverId = CastUtil.cint((Object)m.getInteger("serverId"));
        try {
            this.setInput(objHash, objName, objType, counter, serverId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

