/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;
import scouter.util.StringUtil;

public class CounterTodayAllView
extends ScouterViewPart
implements RefreshThread.Refreshable,
ObjectSelectManager.IObjectCheckListener {
    public static final String ID = CounterTodayAllView.class.getName();
    protected String objType;
    protected String counter;
    protected int serverId;
    protected RefreshThread thread;
    IWorkbenchWindow window;
    IToolBarManager man;
    Trace nearestTrace;
    boolean isActive = false;
    protected Map<Integer, CircularBufferDataProvider> datas = new HashMap<Integer, CircularBufferDataProvider>();
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;
    ArrayList<Trace> traces = new ArrayList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
    }

    @Override
    public void refresh() {
        ArrayList values;
        block5: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            values = new ArrayList();
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    this.isActive = false;
                    tcp.process("COUNTER_TODAY_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            values.add((MapPack)in.readPack());
                            CounterTodayAllView.this.isActive = true;
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterTodayAllView.this.isActive) {
                    CounterTodayAllView.this.setActive();
                } else {
                    CounterTodayAllView.this.setInactive();
                }
                String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(CounterTodayAllView.this.serverId));
                try {
                    double max = 0.0;
                    long stime = DateUtil.getTime((String)date, (String)"yyyyMMdd");
                    long etime = stime + 86400000L;
                    CounterTodayAllView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                    long now = TimeUtil.getCurrentTime(CounterTodayAllView.this.serverId);
                    for (MapPack pack : values) {
                        int objHash = pack.getInt("objHash");
                        ListValue time = pack.getList("time");
                        ListValue value = pack.getList("value");
                        CircularBufferDataProvider data = CounterTodayAllView.this.getDataProvider(objHash);
                        data.clearTrace();
                        int i = 0;
                        while (time != null && i < time.size()) {
                            long x = CastUtil.clong((Object)time.get(i));
                            double y = CastUtil.cdouble((Object)value.get(i));
                            if (x > now) break;
                            data.addSample(new Sample(x, y));
                            ++i;
                        }
                        max = Math.max(ChartUtil.getMax(data.iterator()), max);
                    }
                    if (CounterUtil.isPercentValue(CounterTodayAllView.this.objType, CounterTodayAllView.this.counter)) {
                        CounterTodayAllView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    } else {
                        CounterTodayAllView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CounterTodayAllView.this.canvas.redraw();
                CounterTodayAllView.this.xyGraph.repaint();
            }
        });
        this.checkSettingChange();
    }

    private void checkSettingChange() {
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int width = PManager.getInstance().getInt("lineWidth");
                ArrayList<Trace> arrayList = CounterTodayAllView.this.traces;
                synchronized (arrayList) {
                    for (Trace t : CounterTodayAllView.this.traces) {
                        if (CounterTodayAllView.this.nearestTrace == null && t.getLineWidth() != width) {
                            t.setLineWidth(width);
                        }
                        int objHash = HashUtil.hash((String)t.getName());
                        AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
                        if (agent == null || !agent.isAlive() || agent.getColor() == null) {
                            return;
                        }
                        if (t.getTraceColor() == agent.getColor()) continue;
                        t.setTraceColor(agent.getColor());
                    }
                }
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                int i = 0;
                while (i < CounterTodayAllView.this.traces.size()) {
                    CounterTodayAllView.this.xyGraph.removeTrace(CounterTodayAllView.this.traces.get(i));
                    ++i;
                }
                CounterTodayAllView.this.traces.clear();
                CounterTodayAllView.this.datas.clear();
                CounterTodayAllView.this.thread.interrupt();
            }
        });
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterTodayAllView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowLegendAllowSize(r.width, r.height)) {
                        CounterTodayAllView.this.xyGraph.setShowLegend(true);
                    } else {
                        CounterTodayAllView.this.xyGraph.setShowLegend(false);
                    }
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterTodayAllView.this.setContentDescription(CounterTodayAllView.this.desc);
                    } else {
                        CounterTodayAllView.this.setContentDescription("");
                    }
                    r = CounterTodayAllView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterTodayAllView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        ObjectSelectManager.getInstance().addObjectCheckStateListener(this);
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CounterTodayAllView.this.nearestTrace != null) {
                    CounterTodayAllView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    CounterTodayAllView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = CounterTodayAllView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = CounterTodayAllView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : CounterTodayAllView.this.traces) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = CounterTodayAllView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = CounterTodayAllView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    CounterTodayAllView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (CounterTodayAllView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    CounterTodayAllView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(CounterTodayAllView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x100000E: {
                        int i = 0;
                        while (i < CounterTodayAllView.this.traces.size()) {
                            CounterTodayAllView.this.xyGraph.removeTrace(CounterTodayAllView.this.traces.get(i));
                            ++i;
                        }
                        CounterTodayAllView.this.traces.clear();
                        CounterTodayAllView.this.datas.clear();
                        CounterTodayAllView.this.thread.interrupt();
                    }
                }
            }
        });
        String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId));
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
            counterUnit = server.getCounterEngine().getCounterUnit(this.objType, this.counter);
        }
        this.desc = "\u24e2" + svrName + " | (Today All) [" + date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8) + "]" + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        long from = DateUtil.yyyymmdd((String)date);
        long to = from + 86400000L;
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, this.serverId, this.objType, this.counter, from, to);
        this.thread = new RefreshThread(this, 10000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    private CircularBufferDataProvider getDataProvider(int objHash) {
        CircularBufferDataProvider data = this.datas.get(objHash);
        if (data == null) {
            data = new CircularBufferDataProvider(true);
            this.datas.put(objHash, data);
            data.setBufferSize(288);
            data.setCurrentXDataArray(new double[0]);
            data.setCurrentYDataArray(new double[0]);
            String name = StringUtil.trimToEmpty((String)TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), objHash, this.serverId));
            Trace trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, data);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(AgentColorManager.getInstance().assignColor(this.objType, objHash));
            this.xyGraph.addTrace(trace);
            this.traces.add(trace);
        }
        return data;
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
        ObjectSelectManager.getInstance().removeObjectCheckStateListener(this);
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
            this.xyGraph.repaint();
        }
    }

    @Override
    public void notifyChangeState() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                for (Trace t : CounterTodayAllView.this.traces) {
                    String objName = t.getName();
                    if (ObjectSelectManager.getInstance().isUnselectedObject(HashUtil.hash((String)objName))) {
                        t.setVisible(false);
                        continue;
                    }
                    t.setVisible(true);
                }
                ExUtil.exec((Composite)CounterTodayAllView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        CounterTodayAllView.this.redraw();
                    }
                });
            }
        });
    }
}

