/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.util.List;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.counter.actions.OpenDailyServiceCountAction;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class CounterTodayCountView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterTodayCountView.class.getName();
    protected RefreshThread thread;
    protected String objType;
    protected String counter;
    private String mode;
    protected int serverId;
    private String yesterday;
    private boolean isActive = false;
    double yesterdayMax;
    protected CircularBufferDataProvider traceDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected Trace yesterdayTrace;
    protected FigureCanvas canvas;
    int xAxisUnitWidth;
    int lineWidth;
    boolean writedValueMode = false;
    int lastWritedX;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
    }

    private void getYesterdayData(String date) {
        List<Pack> out;
        block7: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            out = null;
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("counter", this.counter);
                    param.put("date", date);
                    param.put("objType", this.objType);
                    out = tcp.process("COUNTER_PAST_DATE_ALL", (Pack)param);
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final long[] values = new long[24];
        if (out != null) {
            Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, out, this.mode, (byte)3);
            for (long time : valueMap.keySet()) {
                int index;
                int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                values[n] = (long)((double)values[n] + valueMap.get(time));
            }
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CircularBufferDataProvider yesterdayProvider = (CircularBufferDataProvider)CounterTodayCountView.this.yesterdayTrace.getDataProvider();
                yesterdayProvider.clearTrace();
                int i = 0;
                while (i < values.length) {
                    yesterdayProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                    ++i;
                }
                CounterTodayCountView.this.yesterdayMax = ChartUtil.getMax(yesterdayProvider.iterator());
            }
        });
    }

    @Override
    public void refresh() {
        List<Pack> out;
        block8: {
            String date = DateUtil.yyyymmdd((long)(TimeUtil.getCurrentTime(this.serverId) - 86400000L));
            if (!date.equals(this.yesterday)) {
                this.yesterday = date;
                this.getYesterdayData(date);
            }
            this.isActive = false;
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            out = null;
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("counter", this.counter);
                    param.put("objType", this.objType);
                    out = tcp.process("COUNTER_TODAY_ALL", (Pack)param);
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final long[] values = new long[24];
        if (out != null && out.size() > 0) {
            Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, out, this.mode, (byte)3);
            for (long time : valueMap.keySet()) {
                int index;
                int n = index = (int)((long)DateUtil.getDateMillis((long)time) / 3600000L);
                values[n] = (long)((double)values[n] + valueMap.get(time));
            }
            this.isActive = true;
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterTodayCountView.this.isActive) {
                    CounterTodayCountView.this.setActive();
                    CounterTodayCountView.this.traceDataProvider.clearTrace();
                    int i = 0;
                    while (i < values.length) {
                        CounterTodayCountView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)i) + 0.5, CastUtil.cdouble((Object)values[i])));
                        ++i;
                    }
                } else {
                    CounterTodayCountView.this.setInactive();
                }
                if (CounterUtil.isPercentValue(CounterTodayCountView.this.objType, CounterTodayCountView.this.counter)) {
                    CounterTodayCountView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                } else {
                    double max = ChartUtil.getMax(CounterTodayCountView.this.traceDataProvider.iterator());
                    max = Math.max(max, CounterTodayCountView.this.yesterdayMax);
                    CounterTodayCountView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                }
                CounterTodayCountView.this.canvas.redraw();
                CounterTodayCountView.this.xyGraph.repaint();
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterTodayCountView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterTodayCountView.this.setContentDescription(CounterTodayCountView.this.desc);
                    } else {
                        CounterTodayCountView.this.setContentDescription("");
                    }
                    r = CounterTodayCountView.this.canvas.getClientArea();
                    this.lock = false;
                }
                if (CounterTodayCountView.this.xyGraph == null) {
                    return;
                }
                CounterTodayCountView.this.xyGraph.setSize(r.width, r.height);
                CounterTodayCountView.this.lineWidth = r.width / 30;
                CounterTodayCountView.this.trace.setLineWidth(CounterTodayCountView.this.lineWidth);
                CounterTodayCountView.this.yesterdayTrace.setLineWidth(CounterTodayCountView.this.lineWidth);
                CounterTodayCountView.this.xAxisUnitWidth = CounterTodayCountView.this.xyGraph.primaryXAxis.getValuePosition(1.0, false) - CounterTodayCountView.this.xyGraph.primaryXAxis.getValuePosition(0.0, false);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                CounterTodayCountView.this.writedValueMode = false;
                CounterTodayCountView.this.canvas.redraw();
            }

            public void mouseDown(MouseEvent e) {
                CounterTodayCountView.this.writeValue(e.x);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(false);
        this.xyGraph.primaryXAxis.setShowMajorGrid(false);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(24);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.xyGraph.primaryXAxis.setRange(0.0, 24.0);
        this.trace = new Trace("TotalCount", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(15);
        this.trace.setTraceType(Trace.TraceType.BAR);
        this.trace.setAreaAlpha(200);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(this.trace);
        CircularBufferDataProvider yetserdaytraceDataProvider = new CircularBufferDataProvider(true);
        yetserdaytraceDataProvider.setBufferSize(24);
        yetserdaytraceDataProvider.setCurrentXDataArray(new double[0]);
        yetserdaytraceDataProvider.setCurrentYDataArray(new double[0]);
        this.yesterdayTrace = new Trace("YesterdayTotalCount", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, yetserdaytraceDataProvider);
        this.yesterdayTrace.setPointStyle(Trace.PointStyle.NONE);
        this.yesterdayTrace.getYAxis().setFormatPattern("#,##0");
        this.yesterdayTrace.setLineWidth(15);
        this.yesterdayTrace.setTraceType(Trace.TraceType.BAR);
        this.yesterdayTrace.setAreaAlpha(90);
        this.yesterdayTrace.setTraceColor(ColorUtil.getInstance().getColor(16));
        this.xyGraph.addTrace(this.yesterdayTrace);
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String counterDisplay = "";
        String objectDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
            objectDisplay = server.getCounterEngine().getDisplayNameObjectType(this.objType);
            counterUnit = server.getCounterEngine().getCounterUnit(this.objType, this.counter);
        }
        this.desc = "\u24e2" + svrName + " | (Today) [" + objectDisplay + "] " + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        final IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)new OpenDailyServiceCountAction(win, CounterTodayCountView.this.objType, CounterTodayCountView.this.counter, Images.bar, CounterTodayCountView.this.serverId));
            }
        });
        Menu menu = mgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
        this.thread = new RefreshThread(this, 5000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    public void writeValue(int ex) {
        double x = this.xyGraph.primaryXAxis.getPositionValue(ex, false);
        int index = (int)x;
        if (index < 0) {
            return;
        }
        Sample sample = (Sample)this.trace.getDataProvider().getSample(index);
        if (sample != null) {
            double y = sample.getYValue();
            int height = this.xyGraph.primaryYAxis.getValuePosition(y, false);
            int startX = this.xyGraph.primaryXAxis.getValuePosition((int)x, false);
            GC gc = new GC((Drawable)this.canvas);
            Font font = new Font(null, "Verdana", 10, 1);
            gc.setFont(font);
            String value = FormatUtil.print((Object)y, (String)"#,###");
            Point textSize = gc.textExtent(value);
            gc.drawText(value, startX + (this.xAxisUnitWidth - textSize.x) / 2, height - 20, true);
            int ground = this.xyGraph.primaryYAxis.getValuePosition(0.0, false);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(12));
            gc.drawRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.fillRectangle(startX + (this.xAxisUnitWidth - this.lineWidth) / 2, height, this.lineWidth, ground - height);
            gc.dispose();
            this.writedValueMode = true;
            this.lastWritedX = ex;
        }
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

