/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.counter.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.model.RefreshThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CounterUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ScouterViewPart;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CounterTodayTotalView
extends ScouterViewPart
implements RefreshThread.Refreshable {
    public static final String ID = CounterTodayTotalView.class.getName();
    protected String objType;
    protected String counter;
    private String mode;
    protected int serverId;
    protected RefreshThread thread;
    IWorkbenchWindow window;
    IToolBarManager man;
    private String yesterday;
    boolean isActive = false;
    double yesterdayMax;
    protected CircularBufferDataProvider traceDataProvider;
    protected CircularBufferDataProvider yesterdayDataProvider;
    protected XYGraph xyGraph;
    protected Trace trace;
    protected FigureCanvas canvas;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
        this.mode = CounterUtil.getTotalMode(this.objType, this.counter);
    }

    @Override
    public void refresh() {
        ArrayList<Pack> packs;
        block7: {
            String date = DateUtil.yyyymmdd((long)(TimeUtil.getCurrentTime(this.serverId) - 86400000L));
            if (!date.equals(this.yesterday)) {
                this.yesterday = date;
                this.getYesterdayData(date);
            }
            packs = new ArrayList<Pack>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    param.put("mode", CounterUtil.getTotalMode(this.objType, this.counter));
                    this.isActive = false;
                    tcp.process("COUNTER_TODAY_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            packs.add(in.readPack());
                        }
                    });
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, packs, this.mode, (byte)3);
        if (valueMap.size() > 0) {
            this.isActive = true;
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (CounterTodayTotalView.this.isActive) {
                    CounterTodayTotalView.this.setActive();
                } else {
                    CounterTodayTotalView.this.setInactive();
                }
                String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(CounterTodayTotalView.this.serverId));
                try {
                    long stime = DateUtil.getTime((String)date, (String)"yyyyMMdd");
                    long etime = stime + 86400000L;
                    CounterTodayTotalView.this.xyGraph.primaryXAxis.setRange(stime, etime);
                    CounterTodayTotalView.this.traceDataProvider.clearTrace();
                    Set timeSet = valueMap.keySet();
                    Iterator iterator = timeSet.iterator();
                    while (iterator.hasNext()) {
                        long time = (Long)iterator.next();
                        CounterTodayTotalView.this.traceDataProvider.addSample(new Sample(CastUtil.cdouble((Object)time), CastUtil.cdouble(valueMap.get(time))));
                    }
                    if (CounterUtil.isPercentValue(CounterTodayTotalView.this.objType, CounterTodayTotalView.this.counter)) {
                        CounterTodayTotalView.this.xyGraph.primaryYAxis.setRange(0.0, 100.0);
                    } else {
                        double max = ChartUtil.getMax(CounterTodayTotalView.this.traceDataProvider.iterator());
                        max = Math.max(max, CounterTodayTotalView.this.yesterdayMax);
                        CounterTodayTotalView.this.xyGraph.primaryYAxis.setRange(0.0, max);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CounterTodayTotalView.this.canvas.redraw();
                CounterTodayTotalView.this.xyGraph.repaint();
            }
        });
    }

    private void getYesterdayData(String date) {
        ArrayList<Pack> values;
        block5: {
            values = new ArrayList<Pack>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("date", date);
                    param.put("objType", this.objType);
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_PAST_DATE_ALL", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Pack p = in.readPack();
                            values.add(p);
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final Map<Long, Double> valueMap = ScouterUtil.getLoadTotalMap(this.counter, values, this.mode, (byte)3);
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterTodayTotalView.this.yesterdayDataProvider.clearTrace();
                Set timeSet = valueMap.keySet();
                Iterator iterator = timeSet.iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    CounterTodayTotalView.this.yesterdayDataProvider.addSample(new Sample(CastUtil.cdouble((Object)(time + 86400000L)), CastUtil.cdouble(valueMap.get(time))));
                }
                CounterTodayTotalView.this.yesterdayMax = ChartUtil.getMax(CounterTodayTotalView.this.yesterdayDataProvider.iterator());
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                CounterTodayTotalView.this.yesterday = null;
                CounterTodayTotalView.this.yesterdayDataProvider.clearTrace();
                CounterTodayTotalView.this.traceDataProvider.clearTrace();
                CounterTodayTotalView.this.thread.interrupt();
            }
        });
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterTodayTotalView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    if (ChartUtil.isShowDescriptionAllowSize(r.height)) {
                        CounterTodayTotalView.this.setContentDescription(CounterTodayTotalView.this.desc);
                    } else {
                        CounterTodayTotalView.this.setContentDescription("");
                    }
                    r = CounterTodayTotalView.this.canvas.getClientArea();
                    this.lock = false;
                }
                CounterTodayTotalView.this.xyGraph.setSize(r.width, r.height);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        ScouterUtil.addShowTotalValueListener(this.canvas, this.xyGraph);
        this.createDataProvider();
        this.createYesterdayProvider();
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CounterTodayTotalView.this.yesterday = null;
                    CounterTodayTotalView.this.yesterdayDataProvider.clearTrace();
                    CounterTodayTotalView.this.traceDataProvider.clearTrace();
                    CounterTodayTotalView.this.thread.interrupt();
                }
            }
        });
        String date = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId));
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String svrName = "";
        String counterDisplay = "";
        String counterUnit = "";
        if (server != null) {
            svrName = server.getName();
            counterDisplay = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
            counterUnit = server.getCounterEngine().getCounterUnit(this.objType, this.counter);
        }
        this.desc = "\u24e2" + svrName + " | (Today Total) [" + date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8) + "]" + counterDisplay + (!"".equals(counterUnit) ? " (" + counterUnit + ")" : "");
        try {
            this.setViewTab(this.objType, this.counter, this.serverId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        long from = DateUtil.yyyymmdd((String)date);
        long to = from + 86400000L;
        MenuUtil.createCounterContextMenu(ID, (Control)this.canvas, this.serverId, this.objType, this.counter, from, to);
        this.thread = new RefreshThread(this, 10000);
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", counter:" + this.counter + ", serverId:" + this.serverId);
        this.thread.start();
    }

    private void createDataProvider() {
        this.traceDataProvider = new CircularBufferDataProvider(true);
        this.traceDataProvider.setBufferSize(288);
        this.traceDataProvider.setCurrentXDataArray(new double[0]);
        this.traceDataProvider.setCurrentYDataArray(new double[0]);
        this.trace = new Trace("TOTAL", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.traceDataProvider);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.trace.getXAxis().setFormatPattern("HH:mm:ss");
        this.trace.getYAxis().setFormatPattern("#,##0");
        this.trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        this.trace.setTraceType(Trace.TraceType.AREA);
        this.trace.setTraceColor(ColorUtil.getInstance().TOTAL_CHART_COLOR);
        this.xyGraph.addTrace(this.trace);
        ChartUtil.addSolidLine(this.xyGraph, this.traceDataProvider, ColorUtil.getInstance().TOTAL_CHART_COLOR);
    }

    private void createYesterdayProvider() {
        this.yesterdayDataProvider = new CircularBufferDataProvider(true);
        this.yesterdayDataProvider.setBufferSize(288);
        this.yesterdayDataProvider.setCurrentXDataArray(new double[0]);
        this.yesterdayDataProvider.setCurrentYDataArray(new double[0]);
        Trace yesterdayTrace = new Trace("yesterday_total", this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, this.yesterdayDataProvider);
        yesterdayTrace.setPointStyle(Trace.PointStyle.NONE);
        yesterdayTrace.getXAxis().setFormatPattern("HH:mm:ss");
        yesterdayTrace.getYAxis().setFormatPattern("#,##0");
        yesterdayTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        yesterdayTrace.setAreaAlpha(90);
        yesterdayTrace.setTraceType(Trace.TraceType.AREA);
        yesterdayTrace.setTraceColor(Display.getCurrent().getSystemColor(16));
        this.xyGraph.addTrace(yesterdayTrace);
    }

    @Override
    public void setFocus() {
        this.statusMessage = String.valueOf(this.desc) + " - setInput(String objType:" + this.objType + ", String counter:" + this.counter + ", int serverId:" + this.serverId + ")";
        super.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }
}

