/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import scouter.util.HashUtil;

public class ActiveDbInfo {
    private static ActiveDbInfo instance;
    private static Hashtable<Integer, Hashtable<String, String>> ServerInfo;

    static {
        ServerInfo = new Hashtable();
    }

    public static synchronized ActiveDbInfo getInstance() {
        if (instance == null) {
            instance = new ActiveDbInfo();
        }
        return instance;
    }

    private ActiveDbInfo() {
    }

    public void addServerInfo(int serverId) {
        if (ServerInfo.get(serverId) == null) {
            Hashtable dbInfo = new Hashtable();
            ServerInfo.put(serverId, dbInfo);
        }
    }

    public ArrayList<String> getDbList(int serverId) {
        ArrayList<String> dbList = new ArrayList<String>();
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            for (String dbName : dbInfo.keySet()) {
                dbList.add(dbName);
            }
            return dbList;
        }
        return null;
    }

    public Set<String> keySet(int serverId) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            return dbInfo.keySet();
        }
        return null;
    }

    public String getObjectName(int serverId, String dbname) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            return String.valueOf(dbInfo.get(dbname));
        }
        return null;
    }

    public int getObjectHash(int serverId, String dbname) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null && dbInfo.get(dbname) != null) {
            return HashUtil.hash((String)dbInfo.get(dbname));
        }
        return -1;
    }

    public void setActiveDBInfo(int serverId, Hashtable<String, String> info) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            dbInfo = info;
        }
    }

    public boolean isEmpty(int serverId) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            return dbInfo.isEmpty();
        }
        return true;
    }

    public int size(int serverId) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            return dbInfo.size();
        }
        return 0;
    }

    public void clear(int serverId) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            dbInfo.clear();
        }
    }

    public void put(int serverId, String dbName, String ObjectName) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo != null) {
            dbInfo.put(dbName, ObjectName);
        }
    }

    public Hashtable<String, String> getActiveDBInfo(int serverId) {
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        return dbInfo;
    }

    public boolean equals(int serverId, Hashtable<String, String> other) {
        if (other == null) {
            return false;
        }
        Hashtable<String, String> dbInfo = ServerInfo.get(serverId);
        if (dbInfo == null) {
            return false;
        }
        return dbInfo.equals(other);
    }
}

