/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid;

import org.csstudio.swt.xygraph.figures.Trace;

public enum CubridSingleItem {
    CPU(InfoType.DB_INFO, "Cpu Usage", "CUBRID_DB_SERVER_INFO", "cubrid_server_info_", "cpu_used", 10, Trace.TraceType.BAR, 0, false),
    ACTIVE_SESSION(InfoType.DB_INFO, "Active Sessions", "CUBRID_DB_SERVER_INFO", "cubrid_server_info_", "active_session", 10, Trace.TraceType.BAR, 1, false),
    LOCK_WAIT_SESSIONS(InfoType.DB_INFO, "Lock Wait Sessions", "CUBRID_DB_SERVER_INFO", "cubrid_server_info_", "lock_wait_sessions", 10, Trace.TraceType.SOLID_LINE, 2, false),
    DATA_PAGE_IO_WRITES(InfoType.DB_INFO, "Data Page_IO Writes", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_data_page_iowrites", 10, Trace.TraceType.SOLID_LINE, 3, false),
    DATA_PAGE_IO_READS(InfoType.DB_INFO, "Data Page IO Reads", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_data_page_ioreads", 10, Trace.TraceType.SOLID_LINE, 4, false),
    DATA_PAGE_FETCHES(InfoType.DB_INFO, "Data Page Fetches", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_data_page_fetches", 10, Trace.TraceType.SOLID_LINE, 5, false),
    DATA_PAGE_DIRTIES(InfoType.DB_INFO, "Data Page Dirties", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_data_page_dirties", 10, Trace.TraceType.SOLID_LINE, 6, false),
    DATA_BUFFER_HIT_RATIO(InfoType.DB_INFO, "Data Buffer Hit_Ratio", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "data_page_buffer_hit_ratio", 10, Trace.TraceType.SOLID_LINE, 7, false),
    QUERY_SSCANS(InfoType.DB_INFO, "Query Sscans", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_query_sscans", 10, Trace.TraceType.SOLID_LINE, 8, false),
    SORT_IO_PAGE(InfoType.DB_INFO, "Sort IO_Page", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_sort_io_pages", 10, Trace.TraceType.SOLID_LINE, 9, false),
    SORT_DATA_PAGE(InfoType.DB_INFO, "Sort Data Page", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "num_sort_data_pages", 10, Trace.TraceType.SOLID_LINE, 10, false),
    XASL_PLAN_HIT_RATE(InfoType.DB_INFO, "XASL Plan Hit Rate (%)", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "xasl_plan_hit_rate", 10, Trace.TraceType.AREA, 11, true),
    FILTER_PLAN_HIT_RATE(InfoType.DB_INFO, "Filter Predicate Hit Rate (%)", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "filter_plan_hit_rate", 10, Trace.TraceType.AREA, 12, true),
    TPS(InfoType.BROKER_INFO, "Transaction Per 5 Second", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "as_num_tran", 14, Trace.TraceType.DASH_LINE, 0, false),
    QPS(InfoType.BROKER_INFO, "Query Per 5 Second", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "as_num_query", 14, Trace.TraceType.DASH_LINE, 1, false),
    ERROR_QUERY(InfoType.BROKER_INFO, "Error Query Per 5 Second", "CUBRID_DB_REALTIME_STATUS", "cubrid_db_dump_info_", "as_error_query", 14, Trace.TraceType.DASH_LINE, 2, false);

    private InfoType infoType;
    private String title;
    private String requestCmd;
    private String statusConstants;
    private String counterName;
    private int color;
    private Trace.TraceType traceType;
    private int index;
    private boolean isPercentData;

    private CubridSingleItem(InfoType infoType, String title, String requestCmd, String statusConstants, String counterName, int color, Trace.TraceType traceType, int index, boolean isPercentData) {
        this.infoType = infoType;
        this.title = title;
        this.requestCmd = requestCmd;
        this.statusConstants = statusConstants;
        this.counterName = counterName;
        this.color = color;
        this.traceType = traceType;
        this.index = index;
        this.isPercentData = isPercentData;
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRequestCmd() {
        return this.requestCmd;
    }

    public String getStatusConstants() {
        return this.statusConstants;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public int getColor() {
        return this.color;
    }

    public Trace.TraceType getTraceType() {
        return this.traceType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isPercent() {
        return this.isPercentData;
    }

    public static CubridSingleItem fromCounterName(String title) {
        if (title != null) {
            CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
            int n = cubridSingleItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CubridSingleItem type = cubridSingleItemArray[n2];
                if (title.equalsIgnoreCase(type.title)) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    public static InfoType infotypeFromOrdinal(int ordinal) {
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem type = cubridSingleItemArray[n2];
            if (ordinal == type.ordinal()) {
                return type.infoType;
            }
            ++n2;
        }
        return null;
    }

    public static enum InfoType {
        DB_INFO("DB_INFO"),
        BROKER_INFO("BROKER_INFO");

        private String title;

        private InfoType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

