/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid;

public enum CubridTypeShotPeriod {
    FIVE_MIN("5 min", 300000L),
    TEN_MIN("10 min", 600000L),
    TWT_MIN("20 min", 1200000L),
    THIRTY_MIN("30 min", 1800000L),
    ONE_HOUR("1 hour", 3600000L),
    FOUR_HOURS("4 hours", 14400000L);

    private String label;
    private long time;

    private CubridTypeShotPeriod(String label, long time) {
        this.label = label;
        this.time = time;
    }

    public String getLabel() {
        return this.label;
    }

    public long getTime() {
        return this.time;
    }

    public static CubridTypeShotPeriod fromString(String text) {
        if (text != null) {
            CubridTypeShotPeriod[] cubridTypeShotPeriodArray = CubridTypeShotPeriod.values();
            int n = cubridTypeShotPeriodArray.length;
            int n2 = 0;
            while (n2 < n) {
                CubridTypeShotPeriod b = cubridTypeShotPeriodArray[n2];
                if (text.equalsIgnoreCase(b.label)) {
                    return b;
                }
                ++n2;
            }
        }
        return null;
    }

    public static CubridTypeShotPeriod fromTime(Long time) {
        CubridTypeShotPeriod[] cubridTypeShotPeriodArray = CubridTypeShotPeriod.values();
        int n = cubridTypeShotPeriodArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridTypeShotPeriod b = cubridTypeShotPeriodArray[n2];
            if (time == b.time) {
                return b;
            }
            ++n2;
        }
        return null;
    }
}

