/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import java.awt.Point;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.util.UIUtil;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class AddLongPeriodCalendarDialog {
    private final Display display;
    private final int serverId;
    private final IAddSingleLongPeriodDialog callback;
    Combo dbListCombo;
    Combo counterCombo;

    public AddLongPeriodCalendarDialog(Display display, int serverId, IAddSingleLongPeriodDialog callback) {
        this.display = display;
        this.serverId = serverId;
        this.callback = callback;
    }

    public void show(long stime, long etime) {
        this.show((int)UIUtil.getMousePosition().getX(), (int)UIUtil.getMousePosition().getY(), DateUtil.yyyymmdd((long)stime), DateUtil.yyyymmdd((long)etime));
    }

    public void show() {
        this.show(-1, -1);
    }

    public void show(Point p) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10);
        }
    }

    public void show(int x, int y) {
        this.show("Start Date:", "End Date:", x, y, null, null);
    }

    public void show(int x, int y, String yyyymmdd1, String yyyymmdd2) {
        this.show("Start Date:", "End Date:", x, y, yyyymmdd1, yyyymmdd2);
    }

    public void show(String label1, String label2, int x, int y) {
        this.show(label1, label2, x, y, null, null);
    }

    public void show(String label1, String label2, int x, int y, String yyyymmdd1, String yyyymmdd2) {
        int day;
        int month;
        int year;
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Date");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setText("Counter");
        this.counterCombo = new Combo((Composite)dialog, 12);
        ArrayList<String> multiViewList = new ArrayList<String>();
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem view = cubridSingleItemArray[n2];
            multiViewList.add(view.getTitle());
            ++n2;
        }
        this.counterCombo.setItems(multiViewList.toArray(new String[CubridSingleItem.values().length]));
        this.counterCombo.select(0);
        this.counterCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.counterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSingleItem.infotypeFromOrdinal(AddLongPeriodCalendarDialog.this.counterCombo.getSelectionIndex()).equals((Object)CubridSingleItem.InfoType.BROKER_INFO)) {
                    AddLongPeriodCalendarDialog.this.dbListCombo.setEnabled(false);
                    AddLongPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddLongPeriodCalendarDialog.this.dbListCombo.add("BROKER_INFO");
                    AddLongPeriodCalendarDialog.this.dbListCombo.select(0);
                } else {
                    AddLongPeriodCalendarDialog.this.dbListCombo.setEnabled(true);
                    AddLongPeriodCalendarDialog.this.dbListCombo.removeAll();
                    AddLongPeriodCalendarDialog.this.dbLoad();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label2 = new Label((Composite)dialog, 0);
        Label2.setText("DB");
        this.dbListCombo = new Combo((Composite)dialog, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.dbLoad();
        Label sDate = new Label((Composite)dialog, 0);
        sDate.setText(label1);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        sDate.setLayoutData((Object)data);
        final DateTime startCal = new DateTime((Composite)dialog, 1024);
        data = new GridData(4, 0x1000000, false, false, 4, 1);
        startCal.setLayoutData((Object)data);
        Label eDate = new Label((Composite)dialog, 0);
        eDate.setText(label2);
        data = new GridData(4, 0x1000000, false, false, 4, 1);
        eDate.setLayoutData((Object)data);
        final DateTime endCal = new DateTime((Composite)dialog, 1024);
        data = new GridData(4, 0x1000000, false, false, 4, 1);
        endCal.setLayoutData((Object)data);
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String sDate = String.valueOf(startCal.getMonth() + 1) + "/" + startCal.getDay() + "/" + startCal.getYear();
                            sDate = DateUtil.format((long)DateUtil.getTime((String)sDate, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            String eDate = String.valueOf(endCal.getMonth() + 1) + "/" + endCal.getDay() + "/" + endCal.getYear();
                            eDate = DateUtil.format((long)DateUtil.getTime((String)eDate, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            if (CastUtil.cint((Object)sDate) > CastUtil.cint((Object)eDate)) {
                                MessageDialog.openError((Shell)dialog, (String)"Error", (String)"End Date is later than Start Date");
                                return;
                            }
                            String counterTitle = AddLongPeriodCalendarDialog.this.counterCombo.getText();
                            CubridSingleItem type = CubridSingleItem.fromCounterName(counterTitle);
                            AddLongPeriodCalendarDialog.this.callback.onPressedOk(AddLongPeriodCalendarDialog.this.dbListCombo.getItem(AddLongPeriodCalendarDialog.this.dbListCombo.getSelectionIndex()), type, sDate, eDate);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        AddLongPeriodCalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        if (yyyymmdd1 != null) {
            year = Integer.valueOf(yyyymmdd1.substring(0, 4));
            month = Integer.valueOf(yyyymmdd1.substring(4, 6)) - 1;
            day = Integer.valueOf(yyyymmdd1.substring(6, 8));
            startCal.setDate(year, month, day);
        }
        if (yyyymmdd2 != null) {
            year = Integer.valueOf(yyyymmdd2.substring(0, 4));
            month = Integer.valueOf(yyyymmdd2.substring(4, 6)) - 1;
            day = Integer.valueOf(yyyymmdd2.substring(6, 8));
            endCal.setDate(year, month, day);
        }
        dialog.open();
    }

    private void dbLoad() {
        ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
        if (!activeDBList.isEmpty(this.serverId)) {
            for (String dbName : activeDBList.keySet(this.serverId)) {
                this.dbListCombo.add(dbName);
            }
        } else {
            return;
        }
        this.dbListCombo.select(0);
    }

    public static interface IAddSingleLongPeriodDialog {
        public void onPressedOk(String var1, CubridSingleItem var2, String var3, String var4);

        public void onPressedCancel();
    }
}

