/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import java.awt.Point;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.util.UIUtil;

public class AddLongTransactionList {
    private final Display display;
    private final IAddLongTransactionList callback;
    private final int serverId;
    Combo dbListCombo;

    public AddLongTransactionList(Display display, int serverId, IAddLongTransactionList callback) {
        this.display = display;
        this.callback = callback;
        this.serverId = serverId;
    }

    public void show(Point p) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10);
        }
    }

    public void show() {
        this.show(UIUtil.getMousePosition());
    }

    public void show(int x, int y) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Add ListView");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setLayoutData((Object)new GridData(16384));
        Label2.setText("DB Name:");
        this.dbListCombo = new Combo((Composite)dialog, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.dbLoad();
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            AddLongTransactionList.this.callback.onPressedOk(AddLongTransactionList.this.dbListCombo.getItem(AddLongTransactionList.this.dbListCombo.getSelectionIndex()));
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        AddLongTransactionList.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AddLongTransactionList.this.callback.onPressedCancel();
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    private void dbLoad() {
        ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
        if (!activeDBList.isEmpty(this.serverId)) {
            for (String dbName : activeDBList.keySet(this.serverId)) {
                this.dbListCombo.add(dbName);
            }
        } else {
            return;
        }
        this.dbListCombo.select(0);
    }

    public static interface IAddLongTransactionList {
        public void onPressedOk(String var1);

        public void onPressedCancel();
    }
}

