/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.cubrid.actions;

import java.awt.Point;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.cubrid.ActiveDbInfo;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.cubrid.CubridTypeShotPeriod;
import scouter.client.util.UIUtil;

public class AddRealTimeDialog {
    private final Display display;
    private final IAddSingleRealTimeDialog callback;
    private int serverId;
    Combo dbListCombo;
    Combo counterCombo;
    Combo timeRangeCombo;

    public AddRealTimeDialog(Display display, int serverId, IAddSingleRealTimeDialog callback) {
        this.display = display;
        this.callback = callback;
        this.serverId = serverId;
    }

    public void show(Point p) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10);
        }
    }

    public void show() {
        this.show(UIUtil.getMousePosition());
    }

    public void show(int x, int y) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Add RealTime View");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label Label1 = new Label((Composite)dialog, 0);
        Label1.setLayoutData((Object)new GridData(16384));
        Label1.setText("Counter Name:");
        this.counterCombo = new Combo((Composite)dialog, 12);
        ArrayList<String> multiViewList = new ArrayList<String>();
        CubridSingleItem[] cubridSingleItemArray = CubridSingleItem.values();
        int n = cubridSingleItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubridSingleItem view = cubridSingleItemArray[n2];
            multiViewList.add(view.getTitle());
            ++n2;
        }
        this.counterCombo.setItems(multiViewList.toArray(new String[CubridSingleItem.values().length]));
        this.counterCombo.select(0);
        this.counterCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.counterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CubridSingleItem.infotypeFromOrdinal(AddRealTimeDialog.this.counterCombo.getSelectionIndex()).equals((Object)CubridSingleItem.InfoType.BROKER_INFO)) {
                    AddRealTimeDialog.this.dbListCombo.setEnabled(false);
                    AddRealTimeDialog.this.dbListCombo.removeAll();
                    AddRealTimeDialog.this.dbListCombo.add("BROKER_INFO");
                    AddRealTimeDialog.this.dbListCombo.select(0);
                } else {
                    AddRealTimeDialog.this.dbListCombo.setEnabled(true);
                    AddRealTimeDialog.this.dbListCombo.removeAll();
                    AddRealTimeDialog.this.dbLoad();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label Label2 = new Label((Composite)dialog, 0);
        Label2.setLayoutData((Object)new GridData(16384));
        Label2.setText("DB Name:");
        this.dbListCombo = new Combo((Composite)dialog, 12);
        this.dbListCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.dbLoad();
        Label Label3 = new Label((Composite)dialog, 0);
        Label3.setLayoutData((Object)new GridData(16384));
        Label3.setText("Time Range:");
        this.timeRangeCombo = new Combo((Composite)dialog, 12);
        ArrayList<String> minuteStrList = new ArrayList<String>();
        CubridTypeShotPeriod[] cubridTypeShotPeriodArray = CubridTypeShotPeriod.values();
        int n3 = cubridTypeShotPeriodArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CubridTypeShotPeriod minute = cubridTypeShotPeriodArray[n4];
            minuteStrList.add(minute.getLabel());
            ++n4;
        }
        this.timeRangeCombo.setItems(minuteStrList.toArray(new String[CubridTypeShotPeriod.values().length]));
        this.timeRangeCombo.select(0);
        this.timeRangeCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String counterTitle = AddRealTimeDialog.this.counterCombo.getText();
                            CubridSingleItem type = CubridSingleItem.fromCounterName(counterTitle);
                            String afterMinute = AddRealTimeDialog.this.timeRangeCombo.getText();
                            CubridTypeShotPeriod m = CubridTypeShotPeriod.fromString(afterMinute);
                            if (type.getInfoType() == CubridSingleItem.InfoType.BROKER_INFO) {
                                AddRealTimeDialog.this.callback.onPressedOk(type.getInfoType().getTitle(), type, m.getTime());
                            } else {
                                AddRealTimeDialog.this.callback.onPressedOk(AddRealTimeDialog.this.dbListCombo.getItem(AddRealTimeDialog.this.dbListCombo.getSelectionIndex()), type, m.getTime());
                            }
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        AddRealTimeDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AddRealTimeDialog.this.callback.onPressedCancel();
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    private void dbLoad() {
        ActiveDbInfo activeDBList = ActiveDbInfo.getInstance();
        if (!activeDBList.isEmpty(this.serverId)) {
            for (String dbName : activeDBList.keySet(this.serverId)) {
                this.dbListCombo.add(dbName);
            }
        } else {
            return;
        }
        this.dbListCombo.select(0);
    }

    public static interface IAddSingleRealTimeDialog {
        public void onPressedOk(String var1, CubridSingleItem var2, long var3);

        public void onPressedCancel();
    }
}

